Group: Engineering
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           sympow
Version:        2.023.6
Release:        alt2_10
Summary:        Special Values of Symmetric Power Elliptic Curve L-Functions

# The License tag is a lie.  See
# https://gitlab.com/rezozer/forks/sympow/-/issues/7
License:        BSD-2-Clause AND GPL-2.0-or-later
URL:            https://gitlab.com/rezozer/forks/sympow
Source0:        https://gitlab.com/rezozer/forks/sympow/-/archive/v%{version}/%{name}-v%{version}.tar.bz2
# Do not try to create the cachedir; RPM already created it
Patch0:         sympow-2.023.5-cachedir.patch
# Upstream patch to fix a crash
# https://gitlab.com/rezozer/forks/sympow/-/merge_requests/4
Patch1:         sympow-2.023.6-crash.patch
BuildRequires:  autoconf
BuildRequires:  gcc
BuildRequires:  help2man
BuildRequires:  pari-gp

# See https://fedoraproject.org/wiki/Changes/EncourageI686LeafRemoval
ExcludeArch:    %{ix86}

Requires:       %{name}-data = %{version}-%{release}
Requires:       grep
Requires:       pari-gp
Requires:       sed
Source44: import.info

%description
SYMPOW is a program for computing special values of symmetric power
elliptic curve L-functions.

%package        data
Group: Engineering
Summary:        Shared data for sympow
BuildArch:      noarch

%description    data
This package provides the essential SYMPOW architecture-independent
material, namely shared data and scripts.


%prep
%setup -q -n %{name}-v%{version}
%patch0 -p1
%patch1 -p1



%build
export PREFIX="%{_prefix}"
./Configure

# Do not override Fedora flags
sed -i 's/-O3 //' Makefile

# Put the helper script in a canonical place
cat >> config.h << EOF
#define PKGLIBDIR "%{_libexecdir}/%{name}"
EOF
sed -i 's,%{_prefix}/lib/%{name},%{_libexecdir}/%{name},' Makefile

%make_build


%install
%makeinstall_std
mkdir -p %{buildroot}%{_var}/cache/%{name}

# The install step creates the txt files, so we cannot convert them to bin
# files until now.
mkdir -p binfiles/$(config/endiantuple)
for fil in datafiles/*.txt; do
  NUM=$(grep -Fc AT ${fil} || :)
  if [ "$NUM" -gt 0 ]; then
    ./sympow -txt2bin $NUM binfiles/$(config/endiantuple)/$(basename ${fil/txt/bin}) < $fil
  fi
done
chmod 0644 binfiles/$(config/endiantuple)/*.bin
cp -a binfiles %{buildroot}%{_var}/cache/%{name}/datafiles


%files
%doc HISTORY README.md
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*
%{_var}/cache/%{name}/

%files data
%doc --no-dereference COPYING
%{_datadir}/%{name}/
%{_libexecdir}/%{name}/


%changelog
