Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
BuildRequires: /usr/bin/git
Name:           transifex-client
Version:        0.13.7
Release:        alt1_14
Summary:        Command line tool for Transifex translation management
License:        GPLv2
URL:            http://transifex.org
Source:         https://files.pythonhosted.org/packages/source/t/%{name}/%{name}-%{version}.tar.gz
BuildArch:      noarch

BuildRequires: git
BuildRequires: python3-module-pkg_resources python3-module-setuptools
BuildRequires: python3-devel
BuildRequires: python3-module-six            
BuildRequires: python3-module-slugify            
BuildRequires: python3-module-urllib3
BuildRequires: python3-module-requests
BuildRequires: pip python3-module-pip
BuildRequires: python3-module-mock
BuildRequires: python3-module-requests
BuildRequires: rpm-build-python3dist

Requires: rpm-build-python3
Requires: python3-module-slugify
Requires: python3-module-requests
Requires: python3-module-six

# https://bugzilla.redhat.com/show_bug.cgi?id=1799082
Patch1: 0001-Remove-versioning.patch
Source44: import.info

%description
The Transifex Command-line Client is a command line tool that enables
you to easily manage your translations within a project without the
need of an elaborate UI system.

%prep
%setup -q
git init -q
git config user.name "rpmbuild"
git config user.email "<rpmbuild>"
git config gc.auto 0
git add --force .
git commit -q --allow-empty -a --author "rpmbuild <rpmbuild>" -m "%{NAME}-%{VERSION} base"
cat %_sourcedir/0001-Remove-versioning.patch | git apply --index --reject  -p1 -
git commit -q -m 0001-Remove-versioning.patch --author "rpmbuild <rpmbuild>"


%build
%python3_build

%install
%python3_install

%check            
%{__python3} setup.py test

%files
%doc LICENSE README.md
%{python3_sitelibdir_noarch}/*
%{_bindir}/*

%changelog
