Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install /usr/bin/zip unzip
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           90-Second-Portraits
Version:        1.01b
Release:        alt2_22
Summary:        Frantic street painting game

# Zlib: Main package
# CC-BY-SA-4.0: assets by Tangram Games
# CC-BY-3.0: data/music/monkeys.ogg
# OFL-1.1: data/fonts/neuton.ttf
# MIT: middleclass/
# X11: slam.lua and hump/
License:        Zlib AND CC-BY-SA-4.0 AND CC-BY-3.0 AND OFL-1.1 AND MIT AND X11
URL:            http://tangramgames.dk/games/90secondportraits/
Source0:        https://github.com/SimonLarsen/%{name}/releases/download/%{version}/90secondportraits-%{version}.love#/%{name}-%{version}.zip
#Patch for appdata, manpage, execution script, and desktop file
Patch0:         %{name}-appdata.patch
%if 0%{?fedora} > 28
#https://github.com/SimonLarsen/90-Second-Portraits/pull/6
Patch2:         %{name}-%{version}-love11.patch
%endif

BuildRequires:  desktop-file-utils
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildArch:      noarch
Requires:       love

# List the arches that love builds on
ExclusiveArch: %{arm} %{ix86} x86_64 aarch64 ppc64le riscv64
Source44: import.info

#From the website (see URL above)
%description
90 Second Portraits is a silly speed painting game developed for Ludum Dare 31
Jam competition. Time is money and you have neither! In 90 SECOND PORTRAITS
youa.'re paying the bills by speed painting portraits of bypassing customers!
You have 90 seconds to paint the customer and his/her preferred background!
Your work day ends after 5 customers!

%prep
%setup -q -c
%patch0 -p1
%if 0%{?fedora} > 28
%patch2 -p1
%endif

sed -i 's/VERSION/%{version}/g' appdata/%{name}.6
#Remove non-free font and replace with existing font:
rm data/fonts/yb.ttf
sed -i "s/yb.ttf/neuton.ttf/" *.lua

%build
#love "binary" files are just zipped sources, but should exclude appdata/docs
zip -r %{name}.love . -x appdata/* -x appdata/ -x *.txt -x *.md

%install
#Install love file
install -p -D -m 0644 %{name}.love \
  %{buildroot}/%{_datadir}/%{name}/%{name}.love
#Install execution script
install -p -D -m 0755 appdata/%{name} \
  %{buildroot}/%{_bindir}/%{name}
#Install manpage
install -p -D -m 0644 appdata/%{name}.6 \
  %{buildroot}/%{_mandir}/man6/%{name}.6
#Install appdata.xml and verify
install -p -D -m 0644 appdata/%{name}.appdata.xml \
  %{buildroot}/%{_datadir}/appdata/%{name}.appdata.xml
appstream-util validate-relax --nonet \
  %{buildroot}/%{_datadir}/appdata/*.appdata.xml
#Install desktop, icon:
desktop-file-install \
  --dir %{buildroot}%{_datadir}/applications \
  appdata/%{name}.desktop
install -p -D -m 0644 data/images/title_background.png \
  %{buildroot}/%{_datadir}/pixmaps/%{name}.png

%files
%doc README.md CREDITS.txt
%doc --no-dereference LICENSE.txt middleclass/MIT-LICENSE.txt
%{_mandir}/man6/%{name}.*
%{_bindir}/%{name}
%{_datadir}/%{name}/
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/applications/%{name}.desktop
%{_datadir}/appdata/*.appdata.xml

%changelog
