Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define __cmake_in_source_build 1
Name:       ArpON
Version:    3.0
Release:    alt2_26
Summary:    ARP handler inspection

License:    BSD
URL:        http://arpon.sourceforge.net/
Source0:    http://downloads.sourceforge.net/project/arpon/arpon/ArpON-%{version}/ArpON-%{version}-ng.tar.gz
Patch1:     ArpON-gcc-7-fixes.patch
Patch2:     ArpON-gcc-8-fixes.patch
# See RHBZ#2045151. Patch provided by atu@nmetau.edu.ua
Patch3:     ArpON-atu1.patch

BuildRequires:  gcc
BuildRequires:  libpcap-devel
BuildRequires:  ctest cmake
BuildRequires:  libnet2-devel
BuildRequires:  libdnet-devel
Source44: import.info

%description
ArpON (ARP handler inspection) is a Host-based solution that make the ARP
standardized protocol secure in order to avoid the Man In The Middle (MITM)
attack through the ARP spoofing, ARP cache poisoning or ARP poison routing
attack.

%prep
%setup -q -n %{name}-%{version}-ng
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%{fedora_v2_cmake} -DCMAKE_INSTALL_PREFIX="/" .
make %{?_smp_mflags}

%install
install -D -pm 755 src/arpon %{buildroot}%{_sbindir}/arpon
install -D -pm 644 man8/arpon.8 %{buildroot}%{_mandir}/man8/arpon.8
install -D -pm 644 etc/arpon.conf %{buildroot}/etc/arpon.conf
install -D -pm 644 log/arpon.log %{buildroot}/var/log/arpon.log

%files
%doc --no-dereference LICENSE
%doc AUTHOR CHANGELOG doc/*
%{_sbindir}/arpon
/etc/arpon.conf
/var/log/arpon.log
%{_mandir}/man8/arpon.8*

%changelog
