# as of 1.5.2 underlinked with openexr libraries
%set_verify_elf_method relaxed
Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           CTL
Version:        1.5.2
Release:        alt1_13
Summary:        The Color Transformation Language

License:        AMPAS BSD
URL:            http://github.com/ampas/CTL
Source0:        %{url}/archive/ctl-%{version}/%{name}-%{version}.tar.gz
Patch0:         ctl-1.5.2-dpx.patch
Patch1:         ctl-1.5.2-ilmctl.patch
# https://github.com/ampas/CTL/issues/71
Patch2:         ctl-1.5.2-ilm_230.patch
Patch3:         ctl-gcc11.patch

BuildRequires:  gcc-c++
BuildRequires:  ctest cmake

# http://bugzilla.redhat.com/357461
#A.The CTL license is ok, Free but GPL Incompatible.
BuildRequires:  aces_container-devel
BuildRequires:  ilmbase-devel
BuildRequires:  openexr-devel
BuildRequires:  libtiff-devel libtiffxx-devel

# Provide this package as case-insensitive
Provides: ctl = %{version}-%{release}
# Obsoletes old libraries - rhbz#1644764
Provides:       OpenEXR_CTL-libs = %{version}-%{release}
Obsoletes:      OpenEXR_CTL-libs < 1.5.2-1
Source44: import.info


%description
The Color Transformation Language, or CTL, is a programming language
for digital color management.


%package        devel
Group: Development/Other
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}
Provides:       OpenEXR_CTL-devel = %{version}-%{release}
Obsoletes:      OpenEXR_CTL-devel < 1.5.2-1

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%package docs
Group: Documentation
Summary:        Documentation for %{name}
BuildArch: noarch

%description docs
This package contains documentation files for %{name}.

%package -n     OpenEXR_CTL
Group: System/Libraries
Summary:        A simplified OpenEXR interface to CTL
Requires:       %{name} = %{version}-%{release}

%description -n  OpenEXR_CTL
exrdpx is an initial version of a CTL-driven file converter
that translates DPX files into OpenEXR files and vice versa.
The conversion between the DPX and OpenEXR color spaces is
handled by CTL transforms.

exr_ctl_exr is an initial version of a program that can bake
the effect of a series of CTL transforms into the pixels of
an OpenEXR file.


%prep
%setup -q -n CTL-ctl-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1



%build
%{fedora_v2_cmake} \
 -DINSTALL_LIB_DIR:PATH=%{_lib} \
 -DINSTALL_CMAKE_DIR:PATH=%{_lib}/cmake/%{name}

%fedora_v2_cmake_build


%install
%fedora_v2_cmake_install
find %{buildroot} -name '*.la' -exec rm -f {} ';'

# Move libraries in the correct place
%if "%{_lib}" == "lib64"
mv  %{buildroot}%{_prefix}/lib/* \
  %{buildroot}%{_prefix}/%{_lib}
rmdir %{buildroot}%{_prefix}/lib
%endif

# Remove installed docs
rm -rf %{buildroot}%{_docdir}
rm -rf %{buildroot}%{_prefix}/doc

# todo fix it
if [ %version = 1.5.2 ]; then
    cat > %buildroot%{_libdir}/pkgconfig/OpenEXR_CTL.pc <<EOF
OpenEXR_includedir=%_includedir/OpenEXR
Name: OpenEXR_CTL
Description: Simplified OpenEXR interface to CTL
Version: %version
Libs: -lIlmImfCtl
Cflags:   -I${OpenEXR_includedir}
EOF
fi

%files
%doc AUTHORS CHANGELOG README.md
%doc --no-dereference LICENSE
%{_libdir}/*.so.*
%{_libdir}/CTL

%files devel
%{_includedir}/CTL/
%{_includedir}/OpenEXR/ImfCtlApplyTransforms.h
%{_libdir}/*.so
%{_libdir}/cmake/CTL/*.cmake
%{_libdir}/pkgconfig/CTL.pc
%{_libdir}/pkgconfig/OpenEXR_CTL.pc

%files docs
%doc doc/CtlManual.pdf doc/CtlManual.doc

%files -n OpenEXR_CTL
%{_bindir}/ctlrender
%{_bindir}/exr_ctl_exr
%{_bindir}/exrdpx


%changelog
