Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global pubdicrhver 20021028
%global zipcodever 20030204
%global cannadicver 0.95c
%global cannadir Canna37p3
%global username      canna
%global apphomedir       %{_localstatedir}/lib/%{username}
%global gecos         Canna Service User
%global _hardened_build 1

Summary: A Japanese character set input system.
Name: Canna
Version: 3.7p3
Release: alt1_56
# lib/RKindep/cksum.c is licensed under 4-clause BSD, otherwise MIT.
License: MIT and BSD with advertising
URL: http://www.nec.co.jp/japanese/product/computer/soft/canna/

Source0: http://osdn.dl.sourceforge.jp/canna/9565/%{cannadir}.tar.bz2
Source1: http://cannadic.oucrc.org/cannadic-%{cannadicver}.tar.gz
Source2: pubdic-bonobo-%{pubdicrhver}.tar.bz2
# Dead link? it seems.
#Source3: http://www.coolbrain.net/dl/shion/shion.tar.gz
Source3: shion.tar.gz
# Source4: http://bonobo.gnome.gr.jp/~nakai/canna/zipcode-%{zipcodever}.tar.bz2
Source4: zipcode-%{zipcodever}.tar.bz2
Source21: dot-canna
Source22: cannaping.c
Source30: canna-tmpfiles.conf
Source31: canna.service

Patch0: Canna-conf.patch
Patch2: Canna-3.6-sharedir.patch
Patch4: Canna-3.6-dont-grab-ctrl-o.patch
Patch5: Canna-3.6-fix-warnings.patch
## some dictionaries were ported from SKK-JISYO.*
Patch17: skk-dictionaries.patch
Patch18: Canna-3.6-cannadic.patch
Patch19: Canna-3.6-shion.patch
Patch21: Canna-3.6-bonobo.patch
# Fix for buffer overrun
Patch23: Canna-3.6-wconv.patch
Patch25: Canna-x86_64.patch
Patch27: Canna-3.7p1-notimeout.patch
Patch28: Canna-oldsock.patch
# Patch from the upstream
Patch40: Canna-3.7p1-fix-duplicated-strings.patch
Patch41: Canna-3.7p3-yenbs.patch
Patch42: Canna-3.7p3-redecl.patch
Patch43: Canna-3.7p3-fix-gcc4-warning.patch
Patch44: Canna-3.7p3-no-strip.patch
Patch45: %{name}-3.7p3-fix-format.patch
Patch50: %{name}-aarch64.patch
# Patches not upstream (yet)
Patch99: %{name}-3.7p3-format-security.patch


Requires(pre): shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
Requires(post): grep coreutils
BuildRequires: gcc
BuildRequires: gcc-common gawk libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-networkd systemd-services systemd-stateless systemd-sysvinit systemd-utils
BuildRequires: xorg-cf-files gccmakedep imake
Source44: import.info

%description
Canna provides a user interface for inputting Japanese characters.
Canna supports Nemacs (Mule), kinput2, and canuum. All of these tools
can then use a single customization file, Romaji-to-Kana conversion
rules and dictionaries, and input Japanese in the same way. Canna
automatically supports Kana-to-Kanji conversions; the conversions are
based on a client-server model.

%package devel
Group: Development/Other
Summary: Header file and library for developing programs which use Canna.
Requires: Canna-libs >= %{version}-%{release}

%package libs
Group: System/Libraries
Summary: The runtime library for Canna.

%description devel
The Canna-devel package contains the development files needed to build
programs that will use the Canna Japanese character input system.

%description libs
The Canna-libs package contains the runtime library for running
programs with the Canna Japanese input system.

%prep
%setup -q -c -a 1 -a 2 -a 3 -a 4
cd %{cannadir}
%patch0 -p1 -b .conffix
%patch2 -p1 -b .share
%patch4 -p1 -b .ctrl-o
%patch5 -p1 -b .warnings
%patch17 -p1 -b .skk
%patch18 -p1 -b .cannadic
%patch19 -p1 -b .shion
%patch21 -p1 -b .bonobo
%patch23 -p1 -b .wconv
%ifarch x86_64
%patch25 -p1 -b .x86_64
%endif
%patch27 -p1 -b .notimeout
%patch28 -p1 -b .oldsock
%patch40 -p1 -b .duplicate
%patch41 -p1 -b .yenbs
%patch42 -p1 -b .redecl
%patch43 -p1 -b .gcc4
%patch44 -p1 -b .no-strip
%patch45 -p1 -b .format
cd ..
%patch50 -p1 -b .aarch64
%patch99 -p1 -b .fmt-sec

for file in %{cannadir}/{cmd/mkromdic/mkromdic.man,lib/RK/RkIntro.man}; do
	iconv -f euc-jp -t utf-8 < "$file" > "${file}_"
	touch -r $file "${file}_"
	mv "${file}_" "$file"
done

cat $RPM_BUILD_DIR/Canna-%{version}/zipcode-%{zipcodever}/zipcode.t \
	$RPM_BUILD_DIR/Canna-%{version}/zipcode-%{zipcodever}/jigyosyo.t | sort \
	> $RPM_BUILD_DIR/Canna-%{version}/%{cannadir}/dic/ideo/words/zipcode.t

cat $RPM_BUILD_DIR/Canna-%{version}/pubdic-bonobo/*.p | sort >> \
	$RPM_BUILD_DIR/Canna-%{version}/%{cannadir}/dic/ideo/pubdic/y.p

# find CVS files and remove it.
find $RPM_BUILD_DIR/%{name}-%{version} -name .cvsignore -exec rm -f {} \;

%build
export RPM_OPT_FLAGS="$RPM_OPT_FLAGS %{__global_ldflags}"

function builddic() {
  dic=$1
  dicname=`echo $dic | sed -e 's/\(.*\)\..*\$/\1/'`
  case $2 in
    mwd)
      mode="mwd";
      flag="-m";
      ;;
    swd)
      mode="swd";
      flag="-s";
      ;;
    *)
      echo "unknown dictionary type: $2";
      exit 1;
      ;;
  esac
  export buildcannadir=$RPM_BUILD_DIR/%{name}-%{version}/%{cannadir}
  if [ "x$3" = "xsort" ]; then
    $buildcannadir/cmd/splitwd/splitword $dic | $buildcannadir/cmd/forsort/forsort -7 | sort | $buildcannadir/cmd/forsort/forsort -8 | $buildcannadir/cmd/mergewd/mergeword > $dicname.$mode
  else
    cat $dic > $dicname.$mode
  fi
  $buildcannadir/cmd/crxdic/crxdic -D $buildcannadir/dic/ideo/grammar/cnj.bits $flag -o $dicname.cbd -n $dicname $dicname.$mode
  $buildcannadir/cmd/crfreq/crfreq -div 512 -o $dicname.cld $dicname.cbd $dicname.$mode
  rm $dicname.$mode
}

cd %{cannadir}
xmkmf
make Makefile
pushd lib/canna
xmkmf
make sglobal.h
popd
find . -name Makefile | xargs sed -i -e 's/^\(\s*CDEBUGFLAGS\s*=.*\)/\1 $(RPM_OPT_FLAGS)/'
%ifarch ia64
sed -i -e 's/-O2//' Makefile
%endif
# ugly hack to avoid X.Org: no such file or directory issue
sed -i -e 's/$(VENDOR_DEFINES)//' Makefile
make canna
gcc $RPM_OPT_FLAGS -o ./misc/cannaping %{SOURCE22} -I./include -L./lib/canna -lcanna
cd ..

cd cannadic-%{cannadicver}
for i in $RPM_BUILD_DIR/Canna-%{version}/%{cannadir}/cmd/*; do \
if [ -d $i ]; then \
  export PATH=$PATH:$i; \
fi \
done;
export RPM_CANNAIDEO_DIR=$RPM_BUILD_DIR/Canna-%{version}/%{cannadir}/dic/ideo
export RPM_CANNACMD_DIR=$RPM_BUILD_DIR/Canna-%{version}/%{cannadir}/cmd
export RPM_CANNA_POD=$RPM_BUILD_DIR/Canna-%{version}/%{cannadir}/dic/ideo/pubdic/pod
builddic gcanna.ctd mwd none
builddic gcannaf.ctd swd none
cd ..

cd pubdic-bonobo
cat *.p | $RPM_CANNA_POD - -p -i -2 > bonobo.spl
$RPM_CANNACMD_DIR/mergewd/mergeword< bonobo.spl > bonobo.t
rm -rf bonobo.spl
builddic bonobo.t mwd sort
cd ..

cd shion
builddic basho.ctd mwd sort
builddic keisan.ctd mwd sort
builddic pub.ctd mwd sort
builddic scien.ctd mwd none
builddic sup.ctd mwd sort
cd ..

%install
cd %{cannadir}
make libCannaDir=%{_libdir} DESTDIR=$RPM_BUILD_ROOT install
make DESTDIR=$RPM_BUILD_ROOT MANDIR=%{_mandir} MANSUFFIX=1 LIBMANSUFFIX=3 install.man
for i in `find $RPM_BUILD_ROOT%{_mandir}/ja -type f`; do
	iconv -f euc-jp -t utf-8 $i > $i.new && touch -r $i $i.new && mv -f $i.new $i && chmod 444 $i
done
install -p -m755 ./misc/cannaping $RPM_BUILD_ROOT%{_bindir}/cannaping
install -d -m 0755 $RPM_BUILD_ROOT%{_tmpfilesdir}
install -p -m 0644 %{SOURCE30} $RPM_BUILD_ROOT%{_tmpfilesdir}/%{name}.conf
cd ..

cd %{cannadir}
mv misc/manual.sed .
rm -fr misc
mkdir misc
mv manual.sed misc
cd ..

cd cannadic-%{cannadicver}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/lib/canna/dic/canna
install -p -m 644 gcanna*.c[bl]d \
	$RPM_BUILD_ROOT%{_localstatedir}/lib/canna/dic/canna
cd ..

cd pubdic-bonobo
install -p -m 644 bonobo*.c[bl]d \
        $RPM_BUILD_ROOT%{_localstatedir}/lib/canna/dic/canna
cd ..

cd shion
install -p -m 644 basho.cld basho.cbd kaom.ctd keisan.cld keisan.cbd \
	pub.cld pub.cbd scien.cld scien.cbd sup.cld sup.cbd \
	$RPM_BUILD_ROOT%{_localstatedir}/lib/canna/dic/canna
cd ..

mkdir -p $RPM_BUILD_ROOT/etc/skel
mkdir -p $RPM_BUILD_ROOT%{_unitdir}
install -p -m 0644 %SOURCE21 $RPM_BUILD_ROOT/etc/skel/.canna
install -p -m 0644 %SOURCE21 $RPM_BUILD_ROOT/etc/canna/default.canna
install -p -m 0644 %SOURCE31 $RPM_BUILD_ROOT%{_unitdir}/canna.service

cat > $RPM_BUILD_ROOT%{_sysconfdir}/hosts.canna << EOF
unix
EOF

cat > $RPM_BUILD_ROOT%{_sysconfdir}/canna/cannahost << EOF
unix
EOF

for bin in addwords cpdic delwords lsdic mkdic mvdic rmdic syncdic ; do
	ln -sf catdic $RPM_BUILD_ROOT%{_bindir}/${bin}
done
ln -sf ../bin/catdic $RPM_BUILD_ROOT%{_sbindir}/cannakill

mv $RPM_BUILD_ROOT%{_sysconfdir}/canna/sample $RPM_BUILD_DIR/%{name}-%{version}
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/run/.iroha_unix

# remove the static libraries
rm -f $RPM_BUILD_ROOT%{_libdir}/lib*.a


%pre
getent group %{username} >/dev/null || groupadd -r %{username}
getent passwd %{username} >/dev/null || useradd -r -g %{username} -d %{apphomedir} -s /sbin/nologin -c '%{gecos}' %{username}
exit 0

%post
if ! grep -q canna /etc/services
then
	echo "canna		5680/tcp" >>/etc/services
fi
%{__chown} -R %{username}:%{username} %{_localstatedir}/lib/canna
%post_service canna

%preun
%preun_service canna

%files
%lang(ja) %doc %{cannadir}/CHANGES.jp %{cannadir}/OCHANGES.jp
%lang(ja) %doc %{cannadir}/README.jp %{cannadir}/RKCCONF.jp %{cannadir}/WHATIS.jp
%doc %{cannadir}/ChangeLog %{cannadir}/README %{cannadir}/WHATIS
%doc %{cannadir}/Canna.conf
%doc $RPM_BUILD_DIR/%{name}-%{version}/sample
%config %{_sysconfdir}/skel/.canna
%config(noreplace) %{_sysconfdir}/hosts.canna
%config(noreplace) %{_sysconfdir}/canna/cannahost
%dir %{_sysconfdir}/canna
%config %{_sysconfdir}/canna/default.canna
%{_tmpfilesdir}/%{name}.conf
%{_bindir}/*
%{_datadir}/canna
%{_mandir}/man1/*
%lang(ja) %{_mandir}/ja/man1/*
%defattr (0755,root,root)
%{_sbindir}/cannaserver
%{_sbindir}/cannakill
%defattr (-,%{username},%{username})
%dir %{_localstatedir}/run/.iroha_unix
%{_localstatedir}/lib/canna
%{_localstatedir}/log/canna
%{_unitdir}/canna.service

%files devel
%{_includedir}/canna/
%{_mandir}/man3/*
%lang(ja) %{_mandir}/ja/man3/*
%{_libdir}/libRKC.so
%{_libdir}/libRKC16.so
%{_libdir}/libcanna.so
%{_libdir}/libcanna16.so


%files libs
%{_libdir}/libRKC.so.*
%{_libdir}/libRKC16.so.*
%{_libdir}/libcanna.so.*
%{_libdir}/libcanna16.so.*

%changelog
