Group: Graphics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-alternatives
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define maj_version 3.1
%define min_version 0013
%define date April2012

# No debuginfo
%define debug_package %{nil}
# Disable strip
%define __strip /bin/true

%ifarch x86_64
%define priority 10
%else
%define priority 5
%endif

Summary: NVIDIA Cg Toolkit
Name: Cg
Version: %{maj_version}.%{min_version}
Release: alt2_20
URL: http://developer.nvidia.com/object/cg_toolkit.html
Source0: http://developer.download.nvidia.com/cg/Cg_%{maj_version}/Cg-%{maj_version}_%{date}_x86.tgz
Source1: http://developer.download.nvidia.com/cg/Cg_%{maj_version}/Cg-%{maj_version}_%{date}_x86_64.tgz
License: Redistributable, no modification permitted and MIT

ExclusiveArch: i686 x86_64

Requires: lib%{name}(%{_target_cpu}) = %{version}-%{release}

BuildRequires:  gcc-c++
BuildRequires:  libfreeglut-devel
BuildRequires:  libGLEW-devel >= 1.5.1
BuildRequires:  libXi-devel
BuildRequires:  libXmu-devel
Source44: import.info



%description
The Cg Toolkit provides a compiler for the Cg language, runtime
libraries for use with both leading graphics APIs, runtime libraries for
CgFX, example applications, and extensive documentation. Supporting over
20 different OpenGL and DirectX profile targets, Cg will allow you to
incorporate stunning interactive effects into your 3D applications.

This is the %{date} release

%package devel
Group: Development/C
Summary: development files for Gg
Requires: libCg = %EVR

%description devel
development files for Gg


%package docs
Group: Documentation
Summary: NVIDIA Cg Toolkit documentation
BuildArch: noarch

%description docs
NVIDIA Cg Toolkit documentation.

%package -n lib%{name}
Group: System/Libraries
Summary: NVIDIA Cg Toolkit shared support library
Provides: lib%{name}(%{_target_cpu}) = %{version}-%{release}

%description -n lib%{name}
This package contains Cg shared support library.

%prep
%ifarch %{ix86}
%setup -q -c %{name}-%{version}
%endif
%ifarch x86_64
%setup -q -c %{name}-%{version} -D -T -a 1
%endif

#Remove binary bundled tools
rm usr/bin/{cginfo,cgfxcat}

#Clean exemples.
for d in $(find usr/local/Cg/examples/OpenGL/{basic,advanced} -type d); do
  pushd ${d} ; make clean ; popd
done

for d in usr/local/Cg/examples/Tools/{cgfxcat,cginfo} usr/local/Cg/examples/OpenGL/glew ; do
  pushd ${d} ; make clean ; popd
done

# Clean Trace
make -C usr/local/Cg/examples/Trace clean


%build
# Nothing to build
echo "Nothing to build,... Well not exactly"

for b in cgfxcat cginfo ; do
    make -C usr/local/Cg/examples/Tools/${b} clean
    sed -i -e 's@-DGLEW_STATIC@@' usr/local/Cg/examples/Tools/${b}/Makefile
    sed -i -e 's@-Wall@$RPM_OPT_FLAGS@' usr/local/Cg/examples/Tools/${b}/Makefile
    make -C usr/local/Cg/examples/Tools/${b} \
    GLEW=%{_prefix} \
    CG_INC_PATH=%{_builddir}/%{buildsubdir}/usr/include \
    CG_LIB_PATH=%{_builddir}/%{buildsubdir}/%{_libdir}
    mv usr/local/Cg/examples/Tools/${b}/${b} usr/bin
    strip usr/bin/${b}
    make -C usr/local/Cg/examples/Tools/${b} clean
done


%install
mkdir -p $RPM_BUILD_ROOT{%{_bindir},%{_includedir},%{_libdir},%{_mandir}}
cp -pr usr/bin/* $RPM_BUILD_ROOT%{_bindir}/
cp -pr usr/include/* $RPM_BUILD_ROOT%{_includedir}/
cp -pr .%{_libdir}/* $RPM_BUILD_ROOT%{_libdir}/

mv $RPM_BUILD_ROOT%{_bindir}/cgc $RPM_BUILD_ROOT%{_bindir}/cgc-%{_lib}

# Owernship of the alternative provides
touch $RPM_BUILD_ROOT%{_bindir}/cgc
for rpm404_ghost in %{_bindir}/cgc
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/cgc_Cg<<EOF
%{_bindir}/cgc	%{_bindir}/cgc-%{_lib}	%{priority}
EOF



%files
%_altdir/cgc_Cg
%{_bindir}/cgc-%{_lib}
%{_bindir}/cgfxcat
%{_bindir}/cginfo

%files devel
%{_includedir}/Cg/

%files docs
%doc usr/local/Cg/docs usr/local/Cg/examples

%files -n libCg
%{_libdir}/*.so


%changelog
