Group: Engineering
BuildRequires: texlive-latex-extra
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		E
Version:	2.1
Release:	alt1_2
Summary:	Equational Theorem Prover
License:	GPLv2+ or LGPLv2+
URL:		http://www.eprover.org/
Source0:	http://wwwlehre.dhbw-stuttgart.de/~sschulz/WORK/E_DOWNLOAD/V_%{version}/%{name}.tgz
# Bibliography file, courtesy of Debian, with modifications by Jerry James
Source1:	eprover.bbl
# Unbundle picosat
Patch0:		%{name}-picosat.patch

BuildRequires:	gcc
BuildRequires:	help2man
BuildRequires:	picosat
BuildRequires:	tex(latex)
BuildRequires:	tex(supertabular.sty)
# You can verify the CASC results here: http://www.cs.miami.edu/~tptp/CASC/J4/

Requires:	picosat
Source44: import.info

%description
E is a purely equational theorem prover for full first-order logic.
That means it is a program that you can stuff a mathematical
specification (in first-order format) and a hypothesis into, and which
will then run forever, using up all of your machines' resources.  Very
occasionally it will find a proof for the hypothesis and tell you so.

E's inference core is based on a modified version of the superposition
calculus for equational clausal logic.  Both clausification and
reasoning on the clausal form can be documented in checkable proof
objects.

E was the best-performing open source software prover in the 2008 CADE
ATP System Competition (CASC) in the FOF, CNF, and UEQ divisions.  In
the 2011 competition, it won second place in the FOF division, and
placed highly in CNF and UEQ.

%prep
%setup -q -n %{name}
%patch0 -p0

# Set up Fedora CFLAGS and paths
sed -e "s|^EXECPATH = .*|EXECPATH = $RPM_BUILD_ROOT%{_bindir}|" \
    -e "s|^MANPATH = .*|MANPATH = $RPM_BUILD_ROOT%{_mandir}/man1|" \
    -e "s|^CFLAGS.*|CFLAGS     = $RPM_OPT_FLAGS \$(BUILDFLAGS) -I../include|" \
    -e "s|^LDFLAGS.*|LDFLAGS    = $RPM_LD_FLAGS|" \
    -i Makefile.vars

# Fix the character encoding of one file
iconv -f ISO8859-1 -t UTF-8 DOC/E-REMARKS > DOC/E-REMARKS.utf8
touch -r DOC/E-REMARKS DOC/E-REMARKS.utf8
mv -f DOC/E-REMARKS.utf8 DOC/E-REMARKS

# Preserve timestamps when installing
sed -i 's|cp \$1|cp -p $1|' development_tools/e_install

# Put the bibliography file where LaTeX will see it
cp -p %{SOURCE1} DOC

find */ -name Makefile -exec sed -i -e 's/^\(\t$(LD).*\)/\1 $(LIBS)/' {} \;


%build
# smp_mflags causes unwelcome races, so we will not use it
make remake
make man

%install
make install

%check
./PROVER/eprover -s --tstp-in EXAMPLE_PROBLEMS/TPTP/SYN190-1.p \
  | sed '/Freeing FVIndex/d' | tail -1 > test-results
echo "# SZS status Unsatisfiable" > test-expected-results
diff -u test-results test-expected-results


%files
%doc --no-dereference COPYING
%doc README README.server
%doc DOC/ANNOUNCE
%doc DOC/bug_reporting
%doc DOC/CONTRIBUTORS
%doc DOC/E-*.html
%doc DOC/eprover.pdf
%doc DOC/E-REMARKS
%doc DOC/E-REMARKS.english
%doc DOC/grammar.txt
%doc DOC/NEWS
%doc DOC/sample_proofs.html
%doc DOC/sample_proofs_tstp.html
%doc DOC/TODO
%doc DOC/TSTP_Syntax.txt
%doc DOC/WISHLIST
%{_bindir}/*
%{_mandir}/man1/*

%changelog
