Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/bison /usr/bin/doxygen Falcon-devel libGLU-devel libgd3-devel libglvnd-devel libgtk+2-devel libncurses-devel pkgconfig(dbus-1)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name Falcon
%define version 0.9.6.8
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}
%global host     www.falconpl.org
# latest bugfix release does not come with updated docs
# remove once the releases are synced again
%global docver   %{version}

Name:            Falcon
Version:         0.9.6.8
Release:         alt3_24
Summary:         The Falcon Programming Language
Summary(it):     Il linguaggio di programmazione Falcon

License:        GPLv2+
URL:            http://%{host}/
Source0:        http://%{host}/project_dl/_official_rel/%{name}-%{version}.tgz
Source1:        http://%{host}/project_dl/_official_rel/%{name}-docs-%{docver}.tgz
# Patches from Git for Falcon's mongo modules
Patch0:         Falcon-0.9.6.8-mongo-cmake-linux-x64.patch
Patch1:         Falcon-0.9.6.8-mongo-stdint.patch
Patch2:         Falcon-0.9.6.8-gcc10.patch

%if 0%{?rhel} <= 5
%endif

BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  ctest cmake
BuildRequires:  pkgconfig(libcurl)
BuildRequires:  pkgconfig(libpcre)
BuildRequires:  pkgconfig(sdl)
BuildRequires:  pkgconfig(SDL_image)
BuildRequires:  pkgconfig(SDL_mixer)
BuildRequires:  pkgconfig(SDL_ttf)
BuildRequires:  pkgconfig(sqlite3)
BuildRequires:  pkgconfig(zlib)
Source44: import.info

%description
The Falcon Programming Language is an embeddable scripting language
aiming to empower even simple applications with a powerful,
flexible, extensible and highly configurable scripting engine.

Falcon is also a standalone multiplatform scripting language that
aims to be both simple and powerful.

%description -l it
Il Falcon è un linguaggio di programmazione embeddabile che intende
fornire nuove potenzialità anche a semplici applicazioni, fornendo
loro un potente, flessibie, estendibile e configurabile motore
di scripting.

Falcon è anche uno scripting languge completo e multipiattaforma,
semplice e potente.

%package   devel
Group: Development/Other
Summary:   Development files for %{name}
Requires:  %{name} = %{version}-%{release}
Requires:  ctest cmake

%description devel
The Falcon Programming Language is an embeddable scripting language
aiming to empower even simple applications with a powerful,
flexible, extensible and highly configurable scripting engine.

Falcon is also a standalone multiplatform scripting language that
aims to be both simple and powerful.

This package contains development files for %{name}. This is not
necessary for using the %{name} interpreter.

%package   doc
Group: Documentation
Summary:   Documentation for %{name}
Requires:  %{name} = %{version}-%{release}
BuildArch: noarch

%description doc
The Falcon Programming Language is an embeddable scripting language
aiming to empower even simple applications with a powerful,
flexible, extensible and highly configurable scripting engine.

Falcon is also a standalone multiplatform scripting language that
aims to be both simple and powerful.

This package contains HTML documentation for %{name}.


%prep
%setup -q -a1
%patch0 -p1 -b .mongo-cmake-linux-x64
%patch1 -p1 -b .mongo-stdint
%patch2 -p1 -b .gcc10


%build
export CXXFLAGS="-std=c++14 $RPM_OPT_FLAGS"
reldocdir=$(echo %{_docdir}/%{name} | sed -e 's|^%{_prefix}/||')
%{fedora_v2_cmake} . \
       -DFALCON_SHARE_DIR=$reldocdir
#-DFALCON_LIB_DIR=%{_lib} \
#       -DFALCON_CMAKE_DIR=%{_lib}/falcon/cmake \

%fedora_v2_cmake_build


%install
%fedora_v2_cmake_install
cp -pR %{docver}-html $RPM_BUILD_ROOT%{_docdir}/%{name}





%files
%doc %{_docdir}/%{name}
%exclude %{_docdir}/%{name}/%{docver}-html
%exclude %{_bindir}/falcon-conf
%exclude %{_bindir}/falconeer.fal
%exclude %{_bindir}/faltest
%{_bindir}/*
%exclude %{_mandir}/man1/falcon-conf*
%exclude %{_mandir}/man1/falconeer.fal*
%exclude %{_mandir}/man1/faltest*
%{_libdir}/falcon
%{_libdir}/*.so.*
%{_mandir}/man1/*

%files devel
%{_bindir}/falcon-conf
%{_bindir}/falconeer.fal
%{_bindir}/faltest
%{_includedir}/*
%{_libdir}/*.so
%{_datadir}/cmake/faldoc
%{_mandir}/man1/falcon-conf*
%{_mandir}/man1/falconeer.fal*
%{_mandir}/man1/faltest*

%files doc
%doc %{_docdir}/%{name}/%{docver}-html


%changelog
