Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: imake libGLU-devel libICE-devel libSM-devel libX11-devel libXext-devel libXi-devel libXmu-devel libXt-devel libglvnd-devel libjpeg-devel libopenmotif-devel plib-devel xorg-cf-files zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define snapshot .cvs20141002

Name:           FlightGear-Atlas
Summary:        Flightgear map tools
Version:        0.5.0
Release:        alt1_0.87%{snapshot}

License:        GPLv2+
Source0:        Atlas-%{version}%{snapshot}.tar.bz2
Source1:        Atlas-0.5.0-default-maps.tar.bz2
Patch0:         Atlas-0.5.0-fix-unused-but-set-variable-warning.patch
Patch1:         Atlas-0.5.0-fix-narrowing-conversion-from-int-to-char-error.patch
Patch2:         Atlas-0.5.0-fix-operator-should-have-been-declared-inside-namespace-error.patch
Patch3:         Atlas-0.5.0-fix-removal-of-deprecated-function-in-sgtime.patch
Patch4:         Atlas-0.5.0-add-material-from-corine-landcover-classes.patch
Patch5:         Atlas-0.5.0-remove-assert-about-matching-navaids.patch
Patch6:         Atlas-0.5.0-fix-sgpath-api-change.patch 
URL:            http://atlas.sourceforge.net
BuildRequires:  gcc-c++
BuildRequires:  libfreeglut-devel, curl-devel libpng-devel libpng17-tools, libGLEW-devel, boost-complete
BuildRequires:  libsimgear-devel >= 2.6.0, libOpenSceneGraph-devel, libEGL-devel
BuildRequires:  automake autoconf intltool libtool
Requires:       FlightGear-data
Obsoletes:      fgfs-Atlas < 0.3.1-10
Source44: import.info

%description
Atlas aims to produce and display high quality charts of the world for
users of FlightGear, an open source flight simulator. This is achieved
through two main parts: The map creator (simply called Map) and the
Atlas viewer

%prep
%setup -q -n Atlas
%patch0
%patch1
%patch2
%patch3
%patch4
%patch5
%patch6

find -type f -name '*.[hc]xx' -exec chmod a-x {} \;

%build
./autogen.sh
%configure CXXFLAGS="$RPM_OPT_FLAGS -fPIC" \
        --with-fgbase=%{_datadir}/flightgear \
        --datadir=%{_datadir}/flightgear \
        --enable-simgear-shared
%make_build

%install
make install DESTDIR=$RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT%{_datadir}/flightgear
tar jxf %{SOURCE1} -C $RPM_BUILD_ROOT%{_datadir}/flightgear

# the palette file must be installed
install -d $RPM_BUILD_ROOT%{_datadir}/flightgear/Atlas/Palettes
install -d $RPM_BUILD_ROOT%{_datadir}/flightgear/Atlas/Fonts

install -m 0644 src/data/Fonts/*.txf \
        $RPM_BUILD_ROOT%{_datadir}/flightgear/Atlas/Fonts
install -m 0644 src/data/Palettes/*.ap \
        $RPM_BUILD_ROOT%{_datadir}/flightgear/Atlas/Palettes
install -m 0644 src/data/background.jpg \
        $RPM_BUILD_ROOT%{_datadir}/flightgear/Atlas
install -m 0644 src/data/airplane_image.png \
        $RPM_BUILD_ROOT%{_datadir}/flightgear/Atlas

%files
%doc AUTHORS COPYING NEWS README
%{_bindir}/*
%{_datadir}/flightgear/Atlas

%changelog
