Group: Graphics
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install unzip
# END SourceDeps(oneline)
BuildRequires: libXrandr-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           GREYCstoration
Version:        2.8
Release:        alt1_30
Summary:        An image denoising and interpolation tool
License:        CeCILL
URL:            http://www.greyc.ensicaen.fr/~dtschump/greycstoration/index.html
Source0:        http://downloads.sourceforge.net/cimg/%{name}-%{version}.zip
Source1:        %{name}.png
Patch0:         GREYCstoration-2.8-fixmakefile.patch
Patch1:         GREYCstoration-2.8-libpng15.patch
Patch2:         GREYCstoration-2.8-gcc6.patch
BuildRequires:  gcc-c++
BuildRequires:  libgimp-devel gimp
BuildRequires:  desktop-file-utils
BuildRequires:  libpng-devel libjpeg-devel libtiff-devel libtiffxx-devel libfftw3-devel
Source44: import.info

%description
GREYCstoration is an image regularization algorithm which is able to process
a color image by locally removing small variations of pixel intensities while
preserving significant global image features, such as edges and corners. The
most direct application of image regularization is image denoising. By
extension, it can also be used to inpaint or resize images.


%package gimp
Group: Graphics
Summary:        GREYCstoration image denoising and interpolation plugin for gimp
Requires:       gimp %{name}


%description gimp
GREYCstoration is an image regularization algorithm which is able to process
a color image by locally removing small variations of pixel intensities while
preserving significant global image features, such as edges and corners. The
most direct application of image regularization is image denoising. By
extension, it can also be used to inpaint or resize images.

This package contains the GREYCstoration plugin for gimp.


%package gui
Group: Graphics
Summary:        GREYCstoration image denoising and interpolation tool
Requires:       %{name} icon-theme-hicolor libtcl tcl libtk tk


%description gui
GREYCstoration is an image regularization algorithm which is able to process
a color image by locally removing small variations of pixel intensities while
preserving significant global image features, such as edges and corners. The
most direct application of image regularization is image denoising. By
extension, it can also be used to inpaint or resize images.

This package contains the GREYCstoration GUI.


%prep
%setup -q
%patch0 -p1 -b .fixmakefile
%patch1 -p1 -b .libpng15
%patch2 -p1 -b .gcc6
# Include path for CImg.h is wrong, fix it.
sed -i -r "s|#include \"../CImg.h\"|#include \"CImg.h\"|" src/greycstoration*.cpp
iconv -f iso-8859-1 -t utf-8 Licence_CeCILL_V2-en.txt > Licence_CeCILL_V2-en.txt.conv
mv Licence_CeCILL_V2-en.txt.conv Licence_CeCILL_V2-en.txt
# Fix lib path on lib64 systems
sed -ir "s|/lib|/%{_lib}|" src/Makefile


%build
make -C src %{?_smp_mflags} CFLAGS="%{optflags} -fno-tree-pre" all

# Build desktop icon
cat >%{name}.desktop <<EOF
[Desktop Entry]
Encoding=UTF-8
Name=GREYCstoration
GenericName=(Image noise tool)
Comment=%{summary}
Exec=%{_bindir}/%{name}_gui.tcl
Icon=%{name}.png
Terminal=false
Type=Application
StartupNotify=false
Categories=Graphics;2DGraphics;RasterGraphics;
EOF


%install

mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_libdir}/gimp/2.0/plug-ins/
mkdir -p %{buildroot}%{_datadir}/%{name}
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/96x96/apps
install -m0755 src/greycstoration %{buildroot}%{_bindir}/
install -m0755 src/greycstoration4integration %{buildroot}%{_bindir}/
install -m0755 src/greycstoration4gimp %{buildroot}%{_libdir}/gimp/2.0/plug-ins/
install -m0755 GREYCstoration_gui.tcl %{buildroot}%{_bindir}
install -m0644 %{SOURCE1} %{buildroot}%{_datadir}/icons/hicolor/96x96/apps
desktop-file-install \
        --dir %{buildroot}%{_datadir}/applications \
        %{name}.desktop


%files
%doc README.txt
%doc Licence_CeCILL_V2-en.txt
%{_bindir}/greycstoration
%{_bindir}/greycstoration4integration

%files gimp
%{_libdir}/gimp/2.0/plug-ins/greycstoration4gimp

%files gui
%{_datadir}/icons/hicolor/96x96/apps/%{name}.png
%{_datadir}/applications/*%{name}.desktop
%{_bindir}/%{name}_gui.tcl

%changelog
