%set_verify_elf_method relaxed
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ gcc-fortran
# END SourceDeps(oneline)
%define fedora 19
# %name or %version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name HepMC
%define version 2.06.09
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

Name:		HepMC
Version:	2.06.09
Release:	alt1_5
Summary:	C++ Event Record for Monte Carlo Generators
Group:		System/Libraries

License:	GPLv2+
URL:		http://lcgapp.cern.ch/project/simu/HepMC/
Source0:	http://lcgapp.cern.ch/project/simu/HepMC/download/%{name}-%{version}.tar.gz
Patch0:		%{name}-fix-typo-hierachy-hierarchy.patch
Patch1:		%{name}-examples-makefile.patch
Patch2:		%{name}-examples-hwaend.patch
Patch3:		%{name}-linking.patch
Source44: import.info


%description
The HepMC package is an object oriented event record written in C++
for High Energy Physics Monte Carlo Generators. Many extensions from
HEPEVT, the Fortran HEP standard, are supported: the number of entries
is unlimited, spin density matrices can be stored with each vertex,
flow patterns (such as color) can be stored and traced, integers
representing random number generator states can be stored, and an
arbitrary number of event weights can be included. Particles and
vertices are kept separate in a graph structure, physically similar to
a physics event. The added information supports the modularization of
event generators. The package has been kept as simple as possible with
minimal internal/external dependencies. Event information is accessed
by means of iterators supplied with the package.

%package devel
Summary:	C++ Event Record for Monte Carlo Generators - development files
Group:		Development/C
Requires:	%{name}%{?_isa} = %{version}-%{release}

%description devel
This package provides development files of HepMC.

%package doc
Summary:	C++ Event Record for Monte Carlo Generators - documentation
Group:		Documentation
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description doc
This package provides HepMC manuals and examples.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%configure --with-momentum=GEV --with-length=MM --disable-static
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}

rm %{buildroot}%{_libdir}/libHepMC.la
rm %{buildroot}%{_libdir}/libHepMCfio.la

rm %{buildroot}%{_datadir}/%{name}/examples/pythia8/config.sh
rm %{buildroot}%{_datadir}/%{name}/examples/pythia8/config.csh
rm %{buildroot}%{_datadir}/%{name}/examples/pythia8/README

mkdir -p %{buildroot}%{_pkgdocdir}
mv %{buildroot}%{_datadir}/%{name}/examples %{buildroot}%{_pkgdocdir}
mv %{buildroot}%{_datadir}/%{name}/doc/HepMC2_reference_manual.pdf \
   %{buildroot}%{_pkgdocdir}/%{name}-reference-manual.pdf
mv %{buildroot}%{_datadir}/%{name}/doc/HepMC2_user_manual.pdf \
   %{buildroot}%{_pkgdocdir}/%{name}-user-manual.pdf
install -p -m 644 AUTHORS %{buildroot}%{_pkgdocdir}
install -p -m 644 ChangeLog %{buildroot}%{_pkgdocdir}
install -p -m 644 COPYING %{buildroot}%{_pkgdocdir}
install -p -m 644 README %{buildroot}%{_pkgdocdir}

%check
make check

%files
%{_libdir}/libHepMC.so.*
%{_libdir}/libHepMCfio.so.*
%doc %{_pkgdocdir}/AUTHORS
%doc %{_pkgdocdir}/ChangeLog
%doc %{_pkgdocdir}/COPYING
%doc %{_pkgdocdir}/README

%files devel
%{_libdir}/libHepMC.so
%{_libdir}/libHepMCfio.so
%{_includedir}/%{name}

%files doc
%dir %{_pkgdocdir}
%doc %{_pkgdocdir}/examples
%doc %{_pkgdocdir}/*.pdf
%doc %{_pkgdocdir}/COPYING

%changelog
