Group: Communications
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           LinLog
Version:        0.5
Release:        alt2_20
Summary:        A ham radio logbook for Linux

License:        GPLv2
URL:            http://linlogbook.sourceforge.net/
Source0:        http://downloads.sourceforge.net/linlogbook/linlogbook-%{version}.tar.gz
Source1:        linlogbook.desktop
Source2:        linlogbook.png
Patch0:         LinLog-gcc11.patch

BuildRequires:  gcc-c++
BuildRequires:  libqt4-declarative libqt4-devel libqt4-help qt4-designer qt4-doc-html qt5-declarative-devel qt5-designer qt5-tools
BuildRequires:  libsqlite3-devel >= 3
BuildRequires:  desktop-file-utils
BuildRequires:  libstdc++13-devel
Source44: import.info

%description
LinLogBook is a highly configurable amateur radio logbook for Linux.

It uses an sql-database to store its data. For the ease of use sqlite 3 is
used but it should be possible to use other databases like mysql, for instance.


%prep
%setup -q -n linlogbook
%patch0 -p1


%build
%{qmake_qt4} -o Makefile linlogbook.pro
%make_build


%install
install -p -d %{buildroot}%{_bindir}
install -p -m 755 bin/linlogbook %{buildroot}%{_bindir}/linlogbook

# no upstream .desktop or icon yet
mkdir -p %{buildroot}%{_datadir}/pixmaps/
cp %{SOURCE2} %{buildroot}%{_datadir}/pixmaps/linlogbook.png
desktop-file-install \
        --dir=%{buildroot}%{_datadir}/applications %{SOURCE1}
mkdir -p %{buildroot}%{_datadir}/%{name}
install -p -m 644 sql/basetables.sql %{buildroot}%{_datadir}/%{name}
install -p -m 644 sql/example.sql %{buildroot}%{_datadir}/%{name}
install -p -m 644 sql/statistics.sql %{buildroot}%{_datadir}/%{name}


%files
%doc --no-dereference COPYING
%doc ChangeLog README 
%{_bindir}/linlogbook
%{_datadir}/pixmaps/linlogbook.png
%{_datadir}/applications/linlogbook.desktop
%{_datadir}/%{name}
%{_datadir}/%{name}/*.sql


%changelog
