Group: Publishing
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/desktop-file-install /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global modname 2.4.6

Summary: Open source Church presentation and lyrics projection application
Name: OpenLP
Version: 2.4.6
Release: alt2_13
Source0: https://get.openlp.org/%{version}/OpenLP-%{version}.tar.gz
License: GPLv2
BuildArch: noarch

URL: http://openlp.org/

BuildRequires:  desktop-file-utils
BuildRequires:  python3-devel
BuildRequires:  python3-module-distribute

Requires:       python3-module-PyQt5
Requires:       python3-module-PyQt5
Requires:       python3-module-beautifulsoup4
Requires:       python3-module-chardet
Requires:       python3-module-lxml
Requires:       python3-module-sqlalchemy
Requires:       python3-module-enchant
Requires:       python3-module-mako
Requires:       python3-module-openoffice
Requires:       python3-module-alembic
Requires:       icon-theme-hicolor
Requires:       libreoffice
Requires:       libreoffice
Requires:       mupdf
Source44: import.info
# libreoffice
%filter_from_requires /^python3...pyodbc./d


%description
OpenLP is a church presentation software, for lyrics projection software,
used to display slides of Songs, Bible verses, videos, images, and
presentations via LibreOffice using a computer and projector.

%prep
%setup -q

%build
%{__python3} setup.py build

%install
%{__python3} setup.py install --skip-build -O1 --root %{buildroot}

install -m644 -p -D resources/images/openlp-logo-16x16.png \
   %{buildroot}%{_datadir}/icons/hicolor/16x16/apps/openlp.png
install -m644 -p -D resources/images/openlp-logo-32x32.png \
   %{buildroot}%{_datadir}/icons/hicolor/32x32/apps/openlp.png
install -m644 -p -D resources/images/openlp-logo-48x48.png \
   %{buildroot}%{_datadir}/icons/hicolor/48x48/apps/openlp.png
install -m644 -p -D resources/images/openlp-logo.svg \
   %{buildroot}%{_datadir}/icons/hicolor/scalable/apps/openlp.svg

desktop-file-install \
  --dir %{buildroot}/%{_datadir}/applications \
  resources/openlp.desktop

desktop-file-validate %{buildroot}/%{_datadir}/applications/openlp.desktop

mv %{buildroot}%{_bindir}/openlp.py %{buildroot}%{_bindir}/openlp

mkdir -p %{buildroot}%{_datadir}/openlp/i18n/
mv resources/i18n/*.qm %{buildroot}%{_datadir}/openlp/i18n
mkdir -p %{buildroot}%{_datadir}/mime/packages
cp -p resources/openlp.xml %{buildroot}%{_datadir}/mime/packages

%files
%doc copyright.txt LICENSE
%{_bindir}/openlp
%{_datadir}/mime/packages/openlp.xml
%{_datadir}/applications/openlp.desktop
%{_datadir}/icons/hicolor/*/apps/openlp.*
%{_datadir}/openlp
%{python3_sitelibdir_noarch}/openlp/
%{python3_sitelibdir_noarch}/OpenLP-%{modname}*.egg-info


%changelog
