Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commit 2959cec27825e53d1554a32668f1f7892ca351c7
%global medcommit %(c=%{commit}; echo ${c:0:12})
%global shortcommit %(c=%{commit}; echo ${c:0:7})

Name:           QsLog
Version:        0
Release:        alt2_27.%{shortcommit}git
Summary:        An easy to use logger that is based on Qt's QDebug class
License:        BSD
URL:            https://bitbucket.org/razvanpetru/qslog

Source0:        https://bitbucket.org/razvanpetru/qslog/get/%{shortcommit}.tar.gz

# Don't install docs
Patch0:         QsLog-nodoc.patch
# Install libraries in correct directory
Patch1:         QsLog-libdir.patch

BuildRequires:  gcc-c++
BuildRequires:  libqt4-declarative libqt4-devel libqt4-help qt4-designer qt4-doc-html qt5-declarative-devel qt5-designer qt5-tools
Source44: import.info

%description
QsLog is an easy to use logger that is based on Qt's QDebug class.
Features:
* Six logging levels (from trace to fatal)
* Logging level threshold configurable at runtime.
* Minimum overhead when logging is turned off.
* Supports multiple destinations, comes with file and debug destinations.
* Thread-safe
* Supports logging of common Qt types out of the box.
 
%package devel
Group: Other
Summary:         Development headers and library for QsLog
Requires:        %{name} = %{version}-%{release}

%description devel
This package contains the development headers and libraries necessary
for compiling against QsLog.

%prep
%setup -q -n razvanpetru-qslog-%{medcommit}
%patch0 -p1 -b .nodoc
%patch1 -p1 -b .libdir
# Prepare LICENSE
head -n 25 QsLog.cpp | sed "s|// ||g" > LICENSE
touch -r QsLog.cpp LICENSE

# Fix EOL encoding
for f in QsLog.h QsLogDestConsole.h QsLogLevel.h QsLogDest.h LICENSE; do
    sed 's|\r||g' $f > $f.new && \
    touch -r $f $f.new && \
    mv $f.new $f
done

%build
%qmake_qt4 QsLogSharedLibrary.pro
%make_build

%install
make install INSTALL_ROOT=%{buildroot}



%files
%doc LICENSE QsLogReadme.txt
%{_libdir}/libQsLog.so.*

%files devel
%{_includedir}/QsLog/
%{_libdir}/libQsLog.so

%changelog
