Group: Sciences/Mathematics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: pkgconfig(libtiff-4) tex(dehypht.tex) texlive-dist zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname Cairo
%global packver  1.6-0
%global rlibdir  %{_libdir}/R/library

Name:             R-%{packname}
Version:          1.6.0
Release:          alt1_9
Summary:          Use Cairo for high-quality bitmap, vector, and display output

License:          GPLv2
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}.tar.gz

# Here's the R view of the dependencies world:
# Depends:
# Imports:   R-grDevices, R-graphics
# Suggests:  R-png
# LinkingTo:
# Enhances:

BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-png
BuildRequires:    libcairo-devel >= 1.2
BuildRequires:    libXt-devel
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
R graphics device using cairographics library that can be used to create
high-quality vector (PDF, PostScript and SVG) and bitmap output (PNG, JPEG,
TIFF), and high-quality rendering in displays (X11 and Win32).  Since it uses
the same back-end for all output, copying across formats is WYSIWYG. Files are
created without the dependence on X11 or other external programs. This device
supports alpha channel (semi-transparent drawing) and resulting images can
contain transparent and semi-transparent regions. It is ideal for use in server
environments (file output) and as a replacement for other devices that don't
have Cairo's capabilities such as alpha support or anti-aliasing. Backends are
modular such that any subset of backends is supported.


%prep
%setup -q -c -n %{packname}


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
%{_bindir}/R CMD check %{packname}


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%dir %{rlibdir}/%{packname}/libs
%{rlibdir}/%{packname}/libs/%{packname}.so


%changelog
