Group: Sciences/Mathematics
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with check

%global packname arules
%global ver 1.6
%global packrel 8

%global _description \
Provides the infrastructure for representing, manipulating and analyzing \
transaction data and patterns (frequent itemsets and association rules). \
Also provides C implementations of the association mining algorithms \
Apriori and Eclat. Hahsler, Gruen and Hornik (2005) \
<doi:10.18637/jss.v014.i15>.

Name:             R-%{packname}
Version:          1.6.8
Release:          alt1_4
Source0:          ftp://cran.r-project.org/pub/R/contrib/main/%{packname}_%{ver}-%{packrel}.tar.gz
License:          GPLv3
URL:              https://cran.r-project.org/web/packages/arules/index.html
Summary:          Mining Association Rules and Frequent Itemsets
Source1:          https://github.com/mhahsler/arules/raw/master/LICENSE

BuildRequires:    R-devel, tex(latex)
%if %{with check}
BuildRequires:    R-XML
BuildRequires:    R-testthat
%endif
BuildRequires:    gcc-c++

Requires:         R-base R-tcltk
Source44: import.info

%description 
%_description

%prep
%setup -q -c -n %{packname}
cp %{SOURCE1} .

%build

%install
mkdir -p %{buildroot}%{_libdir}/R/library
%{_bindir}/R CMD INSTALL -l %{buildroot}%{_libdir}/R/library %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *so)
rm -rf %{buildroot}%{_libdir}/R/library/R.css

# we skip only examples (one example suggests pmml which is missing)
%check
%if %{with check}
export _R_CHECK_FORCE_SUGGESTS_=0 LANG=C.UTF-8
%{_bindir}/R CMD check --ignore-vignettes --no-examples %{packname}
%endif

%files
%dir %{_libdir}/R/library/%{packname}
%doc %{_libdir}/R/library/%{packname}/doc
%doc %{_libdir}/R/library/%{packname}/html
%doc %{_libdir}/R/library/%{packname}/NEWS.md
%doc %{_libdir}/R/library/%{packname}/CITATION
%doc --no-dereference LICENSE
%{_libdir}/R/library/%{packname}/DESCRIPTION
%{_libdir}/R/library/%{packname}/INDEX
%{_libdir}/R/library/%{packname}/NAMESPACE
%{_libdir}/R/library/%{packname}/Meta
%{_libdir}/R/library/%{packname}/R
%{_libdir}/R/library/%{packname}/help
%{_libdir}/R/library/%{packname}/data
%{_libdir}/R/library/%{packname}/libs

%changelog
