Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 3

%bcond_with check

%global packname digest
%global packver 0.6.33

Name:             R-%{packname}
Version:          %{packver}
Release:          alt1_%autorelease
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://CRAN.R-project.org/package=%{packname}&version=%{version}#/%{packname}_%{version}.tar.gz
License:          GPLv2+ and BSD and MIT and zlib
Summary:          Create Cryptographic Hash Digest of R Objects
BuildRequires:    R-devel >= 3.4.0, tex(latex) R-base R-tcltk
%if %{with check}
# Test requires:
BuildRequires:    R-simplermarkdown, R-tinytest
%endif
Provides:         bundled(xxhash)
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
Implementation of a function 'digest()' for the creation of hash digests of
arbitrary R objects (using the md5, sha-1, sha-256, crc32, xxhash and
murmurhash algorithms) permitting easy comparison of R language objects, as
well as a function 'hmac()' to create hash-based message authentication code.
The md5 algorithm by Ron Rivest is specified in RFC 1321, the sha-1 and
sha-256 algorithms are specified in FIPS-180-1 and FIPS-180-2, and the crc32
algorithm is described in
ftp://ftp.rocksoft.com/cliens/rocksoft/papers/crc_v3.txt. For md5, sha-1,
sha-256 and aes, this package uses small standalone implementations that were
provided by Christophe Devine. For crc32, code from the zlib library is used.
For sha-512, an implementation by Aaron D. Gifford is used. For xxHash, the
implementation by Yann Collet is used. For murmurhash, an implementation by
Shane Day is used. Please note that this package is not meant to be deployed
for cryptographic purposes for which more comprehensive (and widely tested)
libraries such as OpenSSL should be used.

%package devel
Group: Other
Requires:         %{name} = %{version}-%{release}
Summary:          Header files for compiling against digest

%description devel
Header files for compiling against digest.

%prep
%setup -q -c -n %{packname}

%build

%install
mkdir -p $RPM_BUILD_ROOT%{_libdir}/R/library
%{_bindir}/R CMD INSTALL -l $RPM_BUILD_ROOT%{_libdir}/R/library %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -rf $RPM_BUILD_ROOT%{_libdir}/R/library/R.css

%check
%if %{with check}
# s390x fails this check in spooky ways
%ifnarch s390x
%{_bindir}/R CMD check %{packname}
%endif
%endif

%files
%{_libdir}/R/library/%{packname}/GPL-2
%dir %{_libdir}/R/library/%{packname}
%doc %{_libdir}/R/library/%{packname}/html
%{_libdir}/R/library/%{packname}/DESCRIPTION
%{_libdir}/R/library/%{packname}/INDEX
%{_libdir}/R/library/%{packname}/NAMESPACE
%{_libdir}/R/library/%{packname}/Meta
%{_libdir}/R/library/%{packname}/R
%{_libdir}/R/library/%{packname}/doc/
%{_libdir}/R/library/%{packname}/help
%{_libdir}/R/library/%{packname}/libs/
%{_libdir}/R/library/%{packname}/demo
%{_libdir}/R/library/%{packname}/tinytest

%files devel
%{_libdir}/R/library/%{packname}/include/

%changelog
