Group: Sciences/Mathematics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname  markdown
%global rlibdir  %{_libdir}/R/library

# Vignettes require knitr, but it requires this package.
%global with_doc  0

Name:             R-%{packname}
Version:          1.1
Release:          alt1_16
Summary:          Render Markdown with the C Library 'Sundown'

License:          GPLv2 and ISC
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{version}.tar.gz

# Here's the R view of the dependencies world:
# Depends:
# Imports:   R-utils, R-xfun, R-mime >= 0.3
# Suggests:  R-knitr, R-RCurl
# LinkingTo:
# Enhances:

BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
BuildRequires:    R-xfun
BuildRequires:    R-mime >= 0.3
%if %{with_doc}
BuildRequires:    R-knitr
%endif

# This doesn't exist in Fedora and is basically dead upstream.
Provides:         bundled(sundown) = 07d0d98cec0df93e07debbcf562cac9eaca998f8
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
Provides R bindings to the 'Sundown' Markdown rendering library
(<https://github.com/vmg/sundown>). Markdown is a plain-text formatting syntax
that can be converted to 'XHTML' or other formats. See
<http://en.wikipedia.org/wiki/Markdown> for more information about Markdown.


%package devel
Group: Sciences/Mathematics
Summary:          Development files for %{name}
Requires:         %{name} = %{version}-%{release}

%description devel
Development files for %{name}.


%prep
%setup -q -c -n %{packname}


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
%if %{with_doc}
%{_bindir}/R CMD check %{packname}
%else
_R_CHECK_FORCE_SUGGESTS_=0 %{_bindir}/R CMD check %{packname} --ignore-vignettes
%endif


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/doc
%doc %{rlibdir}/%{packname}/examples
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/COPYING
%{rlibdir}/%{packname}/NOTICE
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%dir %{rlibdir}/%{packname}/libs
%{rlibdir}/%{packname}/libs/%{packname}.so
%{rlibdir}/%{packname}/resources

%files devel
%{rlibdir}/%{packname}/include


%changelog
