Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with check

%global packname pbapply
%global ver 1.7
%global packrel 2

%global _description \
A lightweight package that adds progress bar to vectorized R functions \
('*apply'). The implementation can easily be added to functions where\
showing the progress is useful (e.g. bootstrap). The type and style of\
the progress bar (with percentages or remaining time) can be set through\
options. Supports several parallel processing backends.

Name:             R-%{packname}
Version:          %{ver}.%{packrel}
Release:          alt1_3
Source0:          ftp://cran.r-project.org/pub/R/contrib/main/%{packname}_%{ver}-%{packrel}.tar.gz
License:          GPLv2
URL:              https://cran.rstudio.com/web/packages/pbapply/index.html
Summary:          Adding Progress Bar to '*apply' Functions

BuildRequires:    R-devel, tex(latex) R-base R-tcltk
Requires:         R-base R-tcltk
%if %{with check}
BuildRequires:    R-shiny
%endif

BuildArch:        noarch
Source44: import.info
ExcludeArch: %R_exclude_arches

%description 
%_description

%prep
%setup -q -c -n %{packname}

%build

%install
mkdir -p %{buildroot}%{_datadir}/R/library
%{_bindir}/R CMD INSTALL -l %{buildroot}%{_datadir}/R/library %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -rf %{buildroot}%{_datadir}/R/library/R.css

%check
%if %{with check}
export LANG=C.UTF-8
%{_bindir}/R CMD check --ignore-vignettes %{packname}
%endif

%files
%dir %{_datadir}/R/library/%{packname}
%doc %{_datadir}/R/library/%{packname}/html
%doc %{_datadir}/R/library/%{packname}/NEWS.md
%doc %{_datadir}/R/library/%{packname}/WORDLIST
%{_datadir}/R/library/%{packname}/DESCRIPTION
%{_datadir}/R/library/%{packname}/INDEX
%{_datadir}/R/library/%{packname}/NAMESPACE
%{_datadir}/R/library/%{packname}/Meta
%{_datadir}/R/library/%{packname}/R
%{_datadir}/R/library/%{packname}/help

%changelog
