Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: gcc-c++ tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname stringi
%global packver  1.8.1
%global rlibdir  %{_libdir}/R/library

Name:             R-%{packname}
Version:          %{packver}
Release:          alt1_4
Summary:          Character String Processing Facilities

License:          BSD
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}.tar.gz

# Here's the R view of the dependencies world:
# Depends:
# Imports:   R-tools, R-utils, R-stats
# Suggests:
# LinkingTo:
# Enhances:

BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    icu-utils libicu-devel
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
A multitude of character string/text/natural language processing tools: pattern
searching (e.g., with 'Java'-like regular expressions or the 'Unicode'
collation algorithm), random string generation, case mapping, string
transliteration, concatenation, sorting, padding, wrapping, Unicode
normalisation, date-time formatting and parsing, and many more. They are fast,
consistent, convenient, and - owing to the use of the 'ICU' (International
Components for Unicode) library - portable across all locales and platforms.


%package devel
Group: Other
Summary:          Development files for %{name}
Requires:         %{name} = %{version}-%{release}

%description devel
Development files for %{name}.


%prep
%setup -q -c -n %{packname}

# Remove bundled code.
rm -r %{packname}/src/icu74
sed -i -e '/src\/icu74\//d' %{packname}/MD5


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname} \
    --configure-args="--disable-icu-bundle"
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
%{_bindir}/R CMD check %{packname}


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/html
%doc %{rlibdir}/%{packname}/AUTHORS
%doc %{rlibdir}/%{packname}/CITATION
%{rlibdir}/%{packname}/LICENSE
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%dir %{rlibdir}/%{packname}/libs
%{rlibdir}/%{packname}/libs/%{packname}.so


%files devel
%{rlibdir}/%{packname}/include


%changelog
