Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname tinytest
%global packver  1.4.1
%global rlibdir  %{_datadir}/R/library

Name:             R-%{packname}
Version:          %{packver}
Release:          alt1_5
Summary:          Lightweight and Feature Complete Unit Testing Framework

License:          GPL-3.0-only
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}.tar.gz

# Here's the R view of the dependencies world:
# Depends:
# Imports:   R-parallel, R-utils
# Suggests:
# LinkingTo:
# Enhances:

BuildArch:        noarch
BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    tex(sectsty.sty)
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
Provides a lightweight (zero-dependency) and easy to use unit testing
framework. Main features: install tests with the package. Test results are
treated as data that can be stored and manipulated. Test files are R scripts
interspersed with test commands, that can be programmed over. Fully automated
build-install-test sequence for packages. Skip tests when not run locally (e.g.
on CRAN). Flexible and configurable output printing. Compare computed output
with output stored with the package. Run tests in parallel.  Extensible by
other packages. Report side effects.


%prep
%setup -q -c -n %{packname}


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
%{_bindir}/R CMD check %{packname}


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/doc
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%{rlibdir}/%{packname}/tinytest
%{rlibdir}/%{packname}/CITATION
%{rlibdir}/%{packname}/rstudio


%changelog
