Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global packname uuid
%global packver  1.1
%global packrel  0
%global rlibdir  %{_libdir}/R/library

Name:             R-%{packname}
Version:          %{packver}.%{packrel}
Release:          alt1_6
Summary:          Tools for generating and handling of UUIDs

License:          MIT
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}-%{packrel}.tar.gz

# Here's the R view of the dependencies world:
# Depends:
# Imports:
# Suggests:
# LinkingTo:
# Enhances:

BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    libuuid-devel
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
Tools for generating and handling of UUIDs (Universally Unique
Identifiers).


%prep
%setup -q -c -n %{packname}

# Use system libuuid.
pushd %{packname}
rm configure.ac configure src/Makevars.in src/[a-z]*.[ch]
sed -i -e '/configure/d' -e '/Makevars/d' -e '/src\/[a-z].*.[ch]/d' MD5
rm -r src/config.h.in src/win32
sed -i -e '/config.h/d' MD5
cat > src/Makevars << EOF
PKG_CFLAGS = \$(shell pkg-config --cflags uuid)
PKG_LIBS = \$(shell pkg-config --libs uuid)
EOF
popd


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
%{_bindir}/R CMD check %{packname}


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS
%{rlibdir}/%{packname}/COPYING
%{rlibdir}/%{packname}/LICENSE
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%dir %{rlibdir}/%{packname}/libs
%{rlibdir}/%{packname}/libs/%{packname}.so
%{rlibdir}/%{packname}/include

%changelog
