Group: Sciences/Mathematics
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
# END SourceDeps(oneline)
BuildRequires: gcc-c++
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with suggests
%bcond_with check

%global packname xfun
%global packver  0.39
%global rlibdir  %{_libdir}/R/library

Name:             R-%{packname}
Version:          %{packver}
Release:          alt1_2
Summary:          Miscellaneous Functions to Support Packages Maintained by 'Yihui Xie'

License:          MIT
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://CRAN.R-project.org/package=%{packname}&version=%{version}#/%{packname}_%{version}.tar.gz

# Here's the R view of the dependencies world:
# Depends:
# Imports:   R-stats, R-tools
# Suggests:  R-testit, R-parallel, R-codetools, R-rstudioapi, R-tinytex >= 0.30, R-mime, R-markdown >= 1.5, R-knitr >= 1.42, R-htmltools, R-remotes, R-pak, R-rhub, R-renv, R-curl, R-jsonlite, R-magick, R-yaml, R-rmarkdown
# LinkingTo:
# Enhances:

BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-testit
%if %{with suggests}
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-rstudioapi
BuildRequires:    R-tinytex >= 0.30
BuildRequires:    R-mime
BuildRequires:    R-markdown >= 1.5
BuildRequires:    R-knitr >= 1.42
BuildRequires:    R-htmltools
BuildRequires:    R-remotes
BuildRequires:    R-pak
BuildRequires:    R-renv
BuildRequires:    R-rhub
BuildRequires:    R-curl
BuildRequires:    R-jsonlite
BuildRequires:    R-magick
BuildRequires:    R-yaml
BuildRequires:    R-rmarkdown
%endif
Source44: import.info
ExcludeArch: %R_exclude_arches

%description
Miscellaneous functions commonly used in other packages maintained by
'Yihui Xie'.


%prep
%setup -q -c -n %{packname}


%build


%install
mkdir -p %{buildroot}%{rlibdir}
%{_bindir}/R CMD INSTALL -l %{buildroot}%{rlibdir} %{packname}
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -f %{buildroot}%{rlibdir}/R.css


%check
%if %{with check}
%if %{with suggests}
%{_bindir}/R CMD check %{packname}
%else
_R_CHECK_FORCE_SUGGESTS_=0 %{_bindir}/R CMD check %{packname} --no-vignettes --no-examples
%endif
%endif


%files
%dir %{rlibdir}/%{packname}
%doc %{rlibdir}/%{packname}/doc
%doc %{rlibdir}/%{packname}/html
%{rlibdir}/%{packname}/DESCRIPTION
%doc %{rlibdir}/%{packname}/NEWS.md
%{rlibdir}/%{packname}/LICENSE
%{rlibdir}/%{packname}/INDEX
%{rlibdir}/%{packname}/NAMESPACE
%{rlibdir}/%{packname}/Meta
%{rlibdir}/%{packname}/R
%{rlibdir}/%{packname}/help
%{rlibdir}/%{packname}/scripts
%dir %{rlibdir}/%{packname}/libs
%{rlibdir}/%{packname}/libs/%{packname}.so


%changelog
