Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-R
BuildRequires: tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This is the CRAN name
%global packname zoo
# This is the main package version
%global packver 1.8
# Note that some R packages do not use packrel
%global packrel 12

%global with_suggests 0

%global __suggests_exclude ^R\\((AER|mondate|strucchange|tis|tseries|xts)\\)

Name:             R-%{packname}
Version:          %{packver}.%{packrel}
Release:          alt1_5
License:          GPL-2.0-or-later
URL:              https://CRAN.R-project.org/package=%{packname}
Source0:          https://cran.r-project.org/src/contrib/%{packname}_%{packver}-%{packrel}.tar.gz

Summary:          Z's ordered observations for irregular time series
BuildRequires:    R-devel
BuildRequires:    tex(latex)
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk
BuildRequires:    R-base R-tcltk

%if %{with_suggests}
BuildRequires:    R-AER
BuildRequires:    R-coda
BuildRequires:    R-chron
BuildRequires:    R-ggplot2 >= 3.0.0
BuildRequires:    R-mondate
BuildRequires:    R-scales
BuildRequires:    R-stinepack
BuildRequires:    R-strucchange
BuildRequires:    R-timeDate
BuildRequires:    R-timeSeries
BuildRequires:    R-tis
BuildRequires:    R-tseries
BuildRequires:    R-xts
%endif
Source44: import.info
ExcludeArch: %R_exclude_arches

%package          devel
Group: Development/Other
Summary:          Development files for %{name}
Requires:         %{name} = %{version}-%{release}

%description
An S3 class with methods for totally ordered indexed observations. It is
particularly aimed at irregular time series of numeric vectors/matrices and
factors. zoo's key design goals are independence of a particular index/date/
time class and consistency with with ts and base R by providing methods to
extend standard generics.

%description    devel
The %{name}-devel  package contains Header and libraries files for
developing applications that use %{name}

%prep
%setup -q -c -n %{packname}
#Fix line endings
sed -i -e 's/\r//' zoo/inst/doc/zoo*.Rnw


%build


%install
mkdir -p $RPM_BUILD_ROOT%{_libdir}/R/library
%{_bindir}/R CMD INSTALL -l $RPM_BUILD_ROOT%{_libdir}/R/library %{packname}
# Clean up in advance of check
test -d %{packname}/src && (cd %{packname}/src; rm -f *.o *.so)
rm -rf $RPM_BUILD_ROOT%{_libdir}/R/library/R.css


%check
#We have to use --no-install because we don't have all of the suggested
#dependencies
%{_bindir}/R CMD check --no-install %{packname}


%files
%dir %{_libdir}/R/library/%{packname}
%doc %{_libdir}/R/library/%{packname}/demo
%doc %{_libdir}/R/library/%{packname}/doc
%doc %{_libdir}/R/library/%{packname}/html
%doc %{_libdir}/R/library/%{packname}/CITATION
%doc %{_libdir}/R/library/%{packname}/NEWS
%doc %{_libdir}/R/library/%{packname}/THANKS
%doc %{_libdir}/R/library/%{packname}/WISHLIST
%doc %{_libdir}/R/library/%{packname}/TODO
%{_libdir}/R/library/%{packname}/DESCRIPTION
%{_libdir}/R/library/%{packname}/INDEX
%{_libdir}/R/library/%{packname}/NAMESPACE
%{_libdir}/R/library/%{packname}/Meta
%{_libdir}/R/library/%{packname}/R
%{_libdir}/R/library/%{packname}/help
%{_libdir}/R/library/%{packname}/libs

%files devel
%{_libdir}/R/library/%{packname}/include

%changelog
