Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global debug_package %{nil}

Name:       Random123
Version:    1.14.0
Release:    alt1_2
Summary:    Library of random number generators

License:    BSD
URL:        https://github.com/DEShawResearch/random123/
Source0:    %{url}/archive/v%{version}/%{name}-%{version}.tar.gz
Patch0:     0001-add-missing-headers.patch

# gccfeatures.h mentions what arches are supported
# these aren't on the list
ExcludeArch:    mips64r2 mips32r2 s390

BuildRequires:  doxygen
# For tests
BuildRequires:  gcc gcc-c++
BuildRequires:  patch
Source44: import.info

%description
Random123 is a library of "counter-based" random number generators (CBRNGs), in
which the Nth random number can be obtained by applying a stateless mixing
function to N instead of the conventional approach of using N iterations of a
stateful transformation. CBRNGs were originally developed for use in MD
applications on Anton, but they are ideal for a wide range of applications on
modern multi-core CPUs, GPUs, clusters, and special-purpose hardware. Three
families of non-cryptographic CBRNGs are described in a paper presented at the
SC11 conference: ARS (based on the Advanced Encryption System (AES)), Threefry
(based on the Threefish encryption function), and Philox (based on integer
multiplication). They all satisfy rigorous statistical testing (passing
BigCrush in TestU01), vectorize and parallelize well (each generator can
produce at least 264 independent streams), have long periods (the period of
each stream is at least 2128), require little or no memory or state, and have
excellent performance (a few clock cycles per byte of random output). The
Random123 library can be used with CPU (C and C++) and GPU (CUDA and OpenCL)
applications.

%package devel
Group: Other
Summary:   Development files for %{name}
Provides:  %{name} = %{version}-%{release}

%description devel
Development files for %{name}.

%package doc
Group: Other
Summary:    Documentation for %{name}
BuildArch: noarch

%description doc
Documentation for %{name}.

%prep
%setup -q -n random123-%{version}
cat %_sourcedir/0001-add-missing-headers.patch | patch -p1 -s



%build
# Header only library
pushd docs
    doxygen Doxyfile
popd

%install
mkdir -p -m 0755 $RPM_BUILD_ROOT/%{_includedir}/%{name}/
cp -a include/Random123/*  $RPM_BUILD_ROOT/%{_includedir}/%{name}/

%check
pushd tests
    cp GNUmakefile Makefile
    
    make
popd

%files devel
%doc --no-dereference LICENSE
%{_includedir}/%{name}/

%files doc
%doc examples

%changelog
