Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/hg /usr/bin/qhelpgenerator-qt5 libGL-devel libGLU-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
#
# Copyright (c) 2004-2015 Ralf Corsepius, Ulm, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#

Summary: Volume rendering library for Coin
Name: SIMVoleon
Version: 2.1.0
Release: alt1_6

# Older releases had been licensed GPLv2
License: BSD-3-Clause
URL: http://www.coin3d.org

Source: https://github.com/coin3d/simvoleon/releases/download/simvoleon-%{version}/simvoleon-%{version}-src.tar.gz

BuildRequires: ctest cmake
BuildRequires: gcc-c++
BuildRequires: /usr/bin/iconv
BuildRequires: libcoin3d-devel
BuildRequires: libsoqt-devel
BuildRequires: doxygen

Provides: Coin4-SIMVoleon = %{version}-%{release}
Source44: import.info
Patch33: SIMVoleon-2.0.1-alt-pc.patch

%description
A volume rendering library for Coin.

%package devel
Group: Other
Summary: Development files for SIMVoleon
Requires: %{name} = %{version}-%{release}

Provides: Coin4-SIMVoleon-devel = %{version}-%{release}

%description devel
Development files for SIMVoleon.


%prep
%setup -n simvoleon

# Some sources are ISO-8859-1 encoded
# We want doxygen to generate utf-8 encoded docs from them
for nonUTF8 in \
  lib/VolumeViz/readers/VRVolFileReader.cpp \
; do \
  %{_bindir}/iconv -f ISO-8859-1 -t utf-8 $nonUTF8 > $nonUTF8.conv
  mv -f $nonUTF8.conv $nonUTF8
done

# No timestamps in doxygen generated docs!
sed -i -e 's,HTML_TIMESTAMP.*= YES,HTML_TIMESTAMP = NO,' \
  docs/simvoleon.doxygen.cmake.in
%patch33 -p1


%build
mkdir -p build-%{_build_arch}
pushd build-%{_build_arch}
%{fedora_v2_cmake} -DSIMVOLEON_BUILD_DOCUMENTATION=TRUE \
       -DSIMVOLEON_BUILD_TESTS=FALSE \
       -DSIMVOLEON_BUILD_DOC_MAN=TRUE \
       -S .. -B .

%make_build
popd

%install
pushd build-%{_build_arch}
%makeinstall_std

# Remove stray files
rm -rf %{buildroot}/usr/share/info/SIMVoleon2/
popd

%files
%doc AUTHORS ChangeLog README NEWS
%doc --no-dereference COPYING
%{_libdir}/libSIMVoleon*.so.*

%files devel
%{_docdir}/SIMVoleon/html/
%{_includedir}/VolumeViz/
%{_libdir}/libSIMVoleon.so
%{_libdir}/pkgconfig/%{name}.pc
%{_libdir}/cmake/%{name}-%{version}/
%{_mandir}/man3/**

%changelog
