Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires: libgmp-devel unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global __brp_check_rpaths %{nil}
Summary:        Utilities for the statistical testing of uniform random number generators
Name:           TestU01
Version:        1.2.3
Release:        alt2_20
License:        Custom (Non-Commercial Use Only)
URL:            http://simul.iro.umontreal.ca/testu01/tu01.html
Source0:        http://simul.iro.umontreal.ca/testu01/%{name}.zip

Patch1:         TestU01-format-security.patch
BuildRequires:  gcc-c++
BuildRequires:  glibc-core glibc-timezones glibc-utils iconv
BuildRequires:  texlive texlive-collection-basic
Source44: import.info

%description 
TestU01 is a software library, implemented in the ANSI C language, and offering
a collection of utilities for the empirical statistical testing of uniform
random number generators.

The library implements several types of random number generators in generic
form, as well as many specific generators proposed in the literature or found
in widely-used software. It provides general implementations of the classical
statistical tests for random number generators, as well as several others
proposed in the literature, and some original ones. These tests can be applied
to the generators predefined in the library and to user-defined generators.
Specific tests suites for either sequences of uniform random numbers in [0,1]
or bit sequences are also available. Basic tools for plotting vectors of points
produced by generators are provided as well.

Additional software permits one to perform systematic studies of the
interaction between a specific test and the structure of the point sets
produced by a given family of random number generators. That is, for a given
kind of test and a given class of random number generators, to determine how
large should be the sample size of the test, as a function of the generator's
period length, before the generator starts to fail the test systematically.

%package devel
Group: Development/Other
Summary: Headers and shared object symbolic links for the %{name}
Requires:  %{name} = %{version}-%{release}
%description devel
Headers and shared object symbolic links for the %{name}.

%prep
%setup -q
%patch1 -p1 -b .fix-format-security
# Convert to utf-8
for file in COPYING param/LCGGranger.par; do
    iconv -f ISO-8859-1 -t UTF-8 -o $file.new $file && \
    touch -r $file $file.new && \
    mv $file.new $file
done

%build
%configure
%make_build


%install
%makeinstall_std


rm -rf %{buildroot}%{_libdir}/*.la
rm -rf %{buildroot}%{_libdir}/*.a
rm -rf %{buildroot}%{_bindir}/tcode

%files
%doc README NEWS
%doc --no-dereference  COPYING
%docdir %{_datadir}/%{name}/doc
%dir %{_datadir}/%{name}/
%{_datadir}/%{name}/doc
%{_libdir}/*.so.*

%files devel
%{_includedir}/*
%{_libdir}/*.so
%docdir %{_datadir}/%{name}/examples
%{_datadir}/%{name}/examples
%docdir %{_datadir}/%{name}/param
%{_datadir}/%{name}/param


%changelog
