Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ZipArchive
Version:        4.1.2
Release:        alt2_25
Summary:        Library for accessing zip files

License:        GPLv2+
URL:            http://www.artpol-software.com/ZipArchive/
Source0:        http://www.artpol-software.com/Downloads/ziparchive_src.zip
# switch to Linux version
Patch0:         %{name}-linux-enable.patch
# add autotooled build system
Patch1:         %{name}-autotools.patch
# use system zlib
Patch2:         %{name}-system-zlib.patch
# Fix building with gcc-4.7
Patch3:         %{name}-gcc-4.7.patch 
# Fix ZipArchive not recognising dirs as such in some zips
Patch4:         %{name}-4.1.1-file-attr-fix.patch
# Fix ZipArchive not building with latest version of zlib
Patch5:         %{name}-4.1.1-new-zlib.patch

BuildRequires:  libtool
BuildRequires:  zlib-devel
BuildRequires:  gcc-c++
Source44: import.info

%description
The ZipArchive Library can be used to add compression functionality to your
software. It is written in C++ and offers the following features:
* Compression, decompression and modification of zip archives.
* Segmented archives support (splitting and spanning).
* Unicode support in archives compatible with WinZip.
* Standard zip encryption.


%package        devel
Group: Development/Other
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}


%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%prep
%setup -q -c
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1


for i in ZipArchive/*.txt; do
    sed -i.old 's/\r//' "$i"
    touch -r "$i.old" "$i"
done

cd ZipArchive
rm -rf zlib bzip2
sh ./autogen.sh


%build
cd ZipArchive
%configure --disable-static
%make_build


%install
cd ZipArchive
make install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'

mkdir -p $RPM_BUILD_ROOT%{_libdir}/pkgconfig
install -p -m 644 %{name}.pc $RPM_BUILD_ROOT%{_libdir}/pkgconfig


%files
%doc ZipArchive/License.txt
%{_libdir}/libziparch-%{version}.so

%files devel
%doc ZipArchive/Appnote.txt
%doc ZipArchive/_readme.txt
%{_includedir}/ZipArchive/
%{_libdir}/libziparch.so
%{_libdir}/pkgconfig/%{name}.pc


%changelog
