# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libexpat-devel zip
# END SourceDeps(oneline)
BuildRequires: chrpath
%define fedora 27
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global with_docs 0

Name:           activemq-cpp
Version:        3.9.4
Release:        alt2_1
Summary:        C++ implementation of JMS-like messaging client

Group:          Development/Other
License:        ASL 2.0
URL:            http://activemq.apache.org/cms/
Source0:        http://www.apache.org/dist/activemq/activemq-cpp/%{version}/activemq-cpp-library-%{version}-src.tar.gz
Patch0:         activemq-cpp-3.8.2-system-zlib.patch
# Some local texmf configuration to increase default pool_size.
Patch1:         activemq-cpp-local-texmf.patch
# Openssl 1.1.0
# http://activemq.2283324.n4.nabble.com/activemq-cpp-3-9-4-fails-to-build-fedora-rawhide-openssl-1-1-0e-related-td4724037.html
Patch2:         activemq-cpp-openssl1.patch

BuildRequires:  libssl-devel
BuildRequires:  zlib-devel
%if %{?with_docs}0
BuildRequires:  doxygen
BuildRequires:  graphviz libgraphviz
BuildRequires:  tex(latex)
%endif
BuildRequires:  libaprutil1-devel >= 1.3
BuildRequires:  cppunit-devel >= 1.10.2
BuildRequires:  libuuid-devel
Source44: import.info

%description
activemq-cpp is a JMS-like API for C++ for interfacing with Message 
Brokers such as Apache ActiveMQ.  C++ messaging service helps to make your 
C++ client code much neater and easier to follow. To get a better feel for 
CMS try the API Reference. 
ActiveMQ-CPP is a client only library, a message broker such as Apache 
ActiveMQ is still needed for your clients to communicate.  

%package devel
Summary:        C++ implementation header files for JMS-like messaging
Group:          Development/Other
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig
%if %{?fedora}%{!?fedora:0} >= 12 || %{?rhel}%{!?rhel:0} >= 6
%else
%endif

%description devel
activemq-cpp is a JMS-like API for C++ for interfacing with Message 
Brokers such as Apache ActiveMQ.  C++ messaging service helps to make 
your C++ client code much neater and easier to follow. To get a better
feel for CMS try the API Reference.  ActiveMQ-CPP is a client only 
library, a message broker such as Apache ActiveMQ is still needed 
for your clients to communicate.  

%{name}-devel contains development header files.

%if %{?with_docs}0
%package doc
Summary:        C++ implementation header files for JMS-like messaging
Group:          Documentation
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:      noarch
%endif

%description doc
activemq-cpp is a JMS-like API for C++ for interfacing with Message 
Brokers such as Apache ActiveMQ.  C++ messaging service helps to make 
your C++ client code much neater and easier to follow. To get a better
feel for CMS try the API Reference.  ActiveMQ-CPP is a client only 
library, a message broker such as Apache ActiveMQ is still needed 
for your clients to communicate.  

%{name}-doc contains api documentation.
%endif

%prep
%setup -q -n activemq-cpp-library-%{version}
%patch0 -p1
rm -r src/main/decaf/internal/util/zip
%if %{?with_docs}0
%patch1 -p1
%endif
%patch2 -p1
chmod 644 LICENSE.txt
chmod 644 src/main/activemq/transport/mock/MockTransport.cpp


%build
# Build pdf(30MB) rather than default html(400MB). 
%if %{?with_docs}0
%configure --disable-static --disable-doxygen-html --enable-doxygen-pdf
%else
%configure --disable-static
%endif

%make_build
%if %{?with_docs}0
%make_build  doxygen-run
cp -p texmf.cnf doc/latex/texmf.cnf
%make_build doxygen-pdf
%endif

%install
make install DESTDIR=$RPM_BUILD_ROOT
rm $RPM_BUILD_ROOT/%{_libdir}/lib%{name}.la
rm $RPM_BUILD_ROOT/%{_bindir}/example
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done

%check
make %{?_smp_mflags} check

%files
%{_libdir}/lib%{name}.so.*
%doc LICENSE.txt  NOTICE.txt  README.txt  RELEASE_NOTES.txt

%files devel
%{_libdir}/lib%{name}.so
%{_includedir}/%{name}-%{version}
%{_libdir}/pkgconfig/%{name}.pc
%{_bindir}/activemqcpp-config

%if %{?with_docs}0
%files doc
%doc doc/%{name}.pdf
%endif

%changelog
