# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++ libXxf86dga-devel libode-devel pkgconfig(ogg) pkgconfig(x11) pkgconfig(zlib)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define	svn	5771

Name:		alienarena
Summary:	Multiplayer retro sci-fi deathmatch game
Version:	7.71.6
Release:	alt1_1
License:	GPLv2+
Group:		Games/Other
URL:		http://red.planetarena.org/
# Been so long since a release, we need to use the svn code
# svn export svn://svn.icculus.org/alienarena/trunk alienarena-7.71.6
# svn co svn://svn.icculus.org/alienarena/tags/7.71.6 alienarena-7.71.6
# cd alienarena-7.71.6
# # remove useless files to gain xz compressed 60MB
# rm -rf Tools/ *.dll *.exe vs2010/ lib_zipfiles/
# cd ..
# tar --exclude-vcs -cJf alienarena-7.71.6-svn5771.tar.xz alienarena-7.71.6
Source0:	alienarena-%{version}-svn%{svn}.tar.xz
Source1:	alien-arena.desktop
Source2:	GPL.acebot.txt
Patch3:		alienarena-7.66-no-qglBlitFramebufferEXT.patch
BuildRequires:	pkgconfig(xext)
BuildRequires:	pkgconfig(xxf86vm)
BuildRequires:	pkgconfig(libjpeg)
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(glu)
BuildRequires:	pkgconfig(libcurl)
BuildRequires:	pkgconfig(libpng)
BuildRequires:	pkgconfig(vorbis)
BuildRequires:	pkgconfig(openal)
BuildRequires:	pkgconfig(freetype2)
BuildRequires:	desktop-file-utils
Requires:	%{name}-data = 1:%{version}
Requires:	desktop-file-utils >= 0.9
Requires:	mesa-demos mesa-info
Requires:	libopenal1 openal-qt openal-tools
Requires:	opengl-games-utils
Source44: import.info

%description
Alien Arena : Mercury Edition is an online deathmatch game with over 30
levels, seven modes of play, loads of mutators, built-in bots, multiple
player characters and weapons (with alt-fire modes).

%package	server
Group:		Games/Other
Summary:	Dedicated server for alienarena, the FPS game
Requires:	%{name}-data = 1:%{version}

%description server
Alien Arena : Mercury Edition is an online deathmatch game with over 30
levels, seven modes of play, loads of mutators, built-in bots, multiple
player characters and weapons (with alt-fire modes).

This is the dedicated server.

%package	data
Group:		Games/Other
Summary:	Data files for Alien Arena 2011
Epoch:		1
BuildArch:	noarch

%description data
This is the game data (audio, maps, etc) for Alien Arena.

%prep
%setup -q -n %{name}-%{version}
%patch3 -p1


# Copy license clarification for acebot
cp -p %{SOURCE2} .

# clean up end-line encoding
[[ -e docs/README.txt ]] && sed -i 's/\r//' docs/README.txt

# So, AlienArena now "uses" openal by dlopening the library, which is hardcoded to
# "libopenal.so". That file only lives in openal-devel, so we need to adjust the hardcoding.
LIBOPENAL=`ls %{_libdir}/libopenal.so.? | cut -d "/" -f 4`
sed -i "s|\"libopenal.so\"|\"$LIBOPENAL\"|g" source/unix/qal_unix.c

%build
autoreconf -vfi
export PTHREAD_LIBS="-lpthread"
export PTHREAD_CFLAGS="-pthread"
%configure
%make_build

%install
%makeinstall_std

mkdir -p %{buildroot}%{_datadir}/applications
desktop-file-install --vendor ""			\
	--dir %{buildroot}%{_datadir}/applications	\
	%{SOURCE1}

mkdir -p %{buildroot}%{_datadir}/icons/hicolor/256x256/apps/
mv %{buildroot}%{_datadir}/icons/%{name}/alien-arena.png \
	%{buildroot}%{_datadir}/icons/hicolor/256x256/apps/alien-arena.png

# Fedora's little opengl checker
ln -s opengl-game-wrapper.sh %{buildroot}%{_bindir}/%{name}-wrapper
ln -s %{name}-ded %{buildroot}%{_bindir}/%{name}-server

rm -f %{buildroot}%{_docdir}/%{name}/{INSTALL,alien-arena.desktop}

%files
%doc GPL.acebot.txt docs/README.txt docs/license.txt
%{_bindir}/%{name}
%{_bindir}/%{name}-wrapper
%{_datadir}/applications/alien-arena.desktop
%{_datadir}/icons/hicolor/*/apps/alien-arena.png

%files server
%{_bindir}/%{name}-ded
%{_bindir}/%{name}-server

%files data
%{_datadir}/%{name}/


%changelog
