Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: libspeexdsp-devel pkgconfig(dbus-1) pkgconfig(jack) pkgconfig(libpulse) pkgconfig(samplerate)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           alsa-plugins-freeworld
Version:        1.2.7.1
Release:        alt2_1
Summary:        The ALSA Plugins - freeworld version
# All packages are LGPLv2+ with the exception of samplerate which is GPLv2+
License:        LGPLv2+
URL:            https://www.alsa-project.org/
Source0:        https://www.alsa-project.org//files/pub/plugins/alsa-plugins-%{version}.tar.bz2

BuildRequires:  autoconf automake libtool
BuildRequires:  libalsa-devel >= 1.1.8
BuildRequires:  libavcodec-devel libavdevice-devel libavfilter-devel libavformat-devel libavutil-devel libpostproc-devel libswresample-devel libswscale-devel
Source44: import.info

%description
The Advanced Linux Sound Architecture (ALSA) provides audio and MIDI
functionality to the Linux operating system.

This package includes plugins for ALSA that cannot go to Fedora.

%package a52
Group: Other
Summary:        A52 output plugin using libavcodec
License:        LGPLv2+
#Compatibility with some foreign packaging scheme
Provides:       alsa-plugins-a52 = %{version}-%{release}

%description a52
This plugin converts S16 linear format to A52 compressed stream and
send to an SPDIF output.  It requires libavcodec for encoding the
audio stream.

%package lavrate
Group: Other
Summary:        Rate converter plugin using libavcodec
License:        LGPLv2+
#Compatibility with some foreign packaging scheme
Provides:       alsa-plugins-lavrate = %{version}-%{release}
Obsoletes:	alsa-plugins-lavcrate < 1.1.6-4

%description lavrate
The plugin uses ffmpeg audio resample library to convert audio rates.

%prep
%setup -q -n alsa-plugins-%{version}%{?prever}

%build
%configure --disable-static \
  --disable-maemo-plugin \
  --disable-jack \
  --disable-pulseaudio \
  --disable-samplerate \
  --disable-speexdsp \
  --disable-usbstream \
  --disable-arcamav \
  --disable-mix \
  --disable-oss \
  --with-speex=no

%make_build

%install
%makeinstall_std
find %buildroot -name "*.la" -exec rm {} \;

%files a52
%doc --no-dereference COPYING COPYING.GPL
%doc doc/a52.txt
%dir %{_sysconfdir}/alsa/conf.d
%config(noreplace) %{_sysconfdir}/alsa/conf.d/60-a52-encoder.conf
%dir %{_datadir}/alsa/alsa.conf.d
%{_datadir}/alsa/alsa.conf.d/60-a52-encoder.conf
%dir %{_libdir}/alsa-lib
%{_libdir}/alsa-lib/libasound_module_pcm_a52.so

%files lavrate
%doc --no-dereference COPYING COPYING.GPL
%doc doc/lavrate.txt
%dir %{_sysconfdir}/alsa/conf.d
%config(noreplace) %{_sysconfdir}/alsa/conf.d/10-rate-lav.conf
%dir %{_datadir}/alsa/alsa.conf.d
%{_datadir}/alsa/alsa.conf.d/10-rate-lav.conf
%dir %{_libdir}/alsa-lib
%{_libdir}/alsa-lib/libasound_module_rate_lavrate.so
%{_libdir}/alsa-lib/libasound_module_rate_lavrate_fast.so
%{_libdir}/alsa-lib/libasound_module_rate_lavrate_faster.so
%{_libdir}/alsa-lib/libasound_module_rate_lavrate_high.so
%{_libdir}/alsa-lib/libasound_module_rate_lavrate_higher.so


%changelog
