Group: Development/Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          amanith
Version:       0.3
Release:       alt1_47
Summary:       Crossplatform framework for 2d/3d vector graphics
License:       QPL
URL:           http://www.amanith.org
# Upstream no longer offers this code
# It originally came from: http://www.amanith.org/download/files/amanith_03.tar.gz
Source0:       amanith_03.tar.gz
BuildRequires:  gcc-c++
BuildRequires: libqt3-devel, libfreetype-devel, libjpeg-devel libpng-devel libpng17-tools, zlib-devel
BuildRequires: libXmu-devel, libGLEW-devel, libGLU-devel
BuildRequires: libGL-devel
Patch0:        amanith-0.3-nothirdpartystatic.patch
Patch1:        amanith-0.3-system-glew.patch
Patch3:        amanith-0.3-gcc-C++fix.patch
Patch4:        amanith-0.3-system-libjpeg.patch
Patch5:        amanith-0.3-system-libpng.patch
Patch6:        amanith-0.3-freetype-fix.patch
Patch7:        amanith-0.3-system-freetype.patch
Patch8:        amanith-0.3-gcc43.patch
Patch9:        amanith-0.3-gcc44.patch
Patch10:       amanith-0.3-fix-DSO.patch
Patch11:       amanith-0.3-gcc-constructor-fix.patch
Patch12:       amanith-0.3-libpng15-fix.patch
Source44: import.info

%description
Amanith is an OpenSource C++ CrossPlatform framework designed for 2d & 3d 
vector graphics.  All the framework is heavily based on a light plug-in 
system.

%package devel
Group: Development/Other
Summary:       Development files for amanith
Requires:      %{name} = %{version}-%{release}

%description devel
Development libraries and headers for developing programs that use amanith.

%prep
%setup -q -n %{name}
%patch0 -p1 -b .system
%patch1 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1 -b .DSO
%patch11 -p1 -b .constructor
%patch12 -p1 -b .pngfix
# Boo. Hiss. SGI Free B and GLX files.
rm -rf include/GL/
# Don't need the 3rdpart stuff either.
rm -rf 3rdpart/
chmod -x include/amanith/*.h include/amanith/1d/*.h \
         include/amanith/2d/*.h include/amanith/lang/*.h \
         include/amanith/numerics/*.h include/amanith/geometry/*.h \
         include/amanith/rendering/*.h include/amanith/support/*.h \
         FAQ CHANGELOG INSTALL README LICENSE.QPL doc/amanith.chm \
         src/1d/*.cpp src/2d/*.cpp src/support/*.cpp src/rendering/*.cpp \
         src/*.cpp src/geometry/*.cpp plugins/jpeg/*.cpp src/numerics/*.cpp \
         plugins/fonts/*.cpp plugins/png/*.cpp \
         plugins/jpeg/*.h plugins/png/*.h plugins/fonts/*.h
# convert to utf-8, fix end of line encoding
for i in FAQ CHANGELOG INSTALL README LICENSE.QPL; do
  sed -i -e 's|\r||g' $i
  iconv -f iso-8859-1 -t utf-8 -o $i{.utf8,} 
  mv $i{.utf8,}
done

%build
export AMANITHDIR=$(pwd)
export LD_LIBRARY_PATH=$AMANITHDIR/lib:$LD_LIBRARY_PATH
. /etc/profile.d/qt3dir.sh; export PATH=%_libdir/qt3/bin:$PATH
qmake-qt3 amanith.pro
%make_build

%install
mkdir -p $RPM_BUILD_ROOT%{_libdir}
mkdir -p $RPM_BUILD_ROOT%{_includedir}

# We're using cp instead of install because the symlinks are already
# created correctly.
cp -a lib/*.so* $RPM_BUILD_ROOT%{_libdir}
cp -a plugins/*.so* $RPM_BUILD_ROOT%{_libdir}
cp -a include/amanith $RPM_BUILD_ROOT%{_includedir}



%files
%doc CHANGELOG FAQ LICENSE.QPL README doc/*
%{_libdir}/*.so.*

%files devel
%{_libdir}/*.so
%{_includedir}/amanith/

%changelog
