Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# hardened build if not overriden
%{!?_hardened_build:%global _hardened_build 1}

%if %{?_hardened_build}%{!?_hardened_build:0}
%global cflags_harden -fpie
%global ldflags_harden -pie -z relro -z now
%endif

Summary: An user-space IPIP encapsulation daemon for the ampr network
Name: amprd
Version: 3.0.1
Release: alt1_6
License: GPLv3+
URL: http://www.yo2loj.ro/hamprojects/
BuildRequires: gcc
BuildRequires: dos2unix
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Source0: http://www.yo2loj.ro/hamprojects/%{name}-%{version}.tgz
Source1: amprd.service
Patch0: amprd-3.0-install-fix.patch
Source44: import.info

%description
An user-space IPIP encapsulation daemon with automatic RIPv2 multicast
processing and multiple tunnel support for the ampr network.
All RIPv2 processing, encapsulation, decapsulation and routing happens
inside the daemon and it offers one or more virtual TUN interfaces to
the system for your 44net traffic.

%prep
%setup -q
%patch0 -p1


dos2unix minGlue.h

%build
%make_build CFLAGS="%{optflags} %{?cflags_harden}" LDFLAGS="%{?__global_ldflags} %{?ldflags_harden}"

%install
make %{?_smp_mflags} DESTDIR=%{buildroot} install

# Systemd
install -Dpm 644 %{SOURCE1} %{buildroot}%{_unitdir}/%{name}.service

# Examples
install -Dd %{buildroot}%{_datadir}/%{name}
install -Dpm 644 -t %{buildroot}%{_datadir}/%{name} startup_example.sh interfaces_example

%post
%post_service %{name}

%preun
%preun_service %{name}

%files
%doc COPYING README

%{_sbindir}/amprd
%config(noreplace) %{_sysconfdir}/amprd.conf
%{_datadir}/%{name}
%{_var}/lib/amprd
%{_unitdir}/amprd.service

%changelog
