# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Abstract Machine Test Utility
Name: amtu 
Version: 1.0.8
Release: alt2_19.1
License: CPL
Group: System/Base
URL: http://sourceforge.net/projects/amtueal/
Source0: %{name}-%{version}.tar.gz
Patch1: amtu-1.0.8-doc.patch
Patch2: amtu-1.0.8-init.patch
Patch3: amtu-1.0.8-memsep.patch
Patch4: amtu-1.0.8-net-device.patch
Patch5: amtu-1.0.8-net-device_name.patch
BuildRequires: libaudit-devel
BuildRequires: automake
Requires: chkconfig
Source44: import.info

%description
Abstract Machine Test Utility (AMTU) is an administrative utility to check
whether the underlying protection mechanism of the hardware are still being
enforced. This is a requirement of the Controlled Access Protection Profile
FPT_AMT.1, see 
http://www.radium.ncsc.mil/tpep/library/protection_profiles/CAPP-1.d.pdf

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%build
%add_optflags -fcommon
LDFLAGS=-Wl,--allow-multiple-definition
touch ChangeLog
touch NEWS
touch AUTHORS
autoreconf -fv --install
%configure
%make_build

%install
make "DESTDIR=${RPM_BUILD_ROOT}" "bindir=%{_sbindir}" install

#%post
#/sbin/chkconfig --add amtu

#%preun
#if [ $1 -eq 0 ]; then
#   /sbin/service amtu stop > /dev/null 2>&1
#   /sbin/chkconfig --del amtu
#fi

%files
%doc doc/AMTUHowTo.txt LICENSE
#%attr(755,root,root) /etc/rc.d/init.d/amtu
#%config(noreplace) %attr(640,root,root) /etc/sysconfig/amtu
%attr(0750,root,root) %{_sbindir}/amtu
%attr(0644,root,root) %{_mandir}/man8/*

%changelog
