Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python rpm-build-python3
# END SourceDeps(oneline)
%define fedora 34
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global archive_name ansible-inventory-grapher
%global lib_name ansibleinventorygrapher

%if 0%{?fedora} >= 29 || 0%{?rhel} >= 8
# Ansible stopped shipping Python 2 modules in Fedora 29+
%bcond_with python2
%else
%bcond_without python2
%endif

Name:           %{archive_name}
Version:        2.5.0
Release:        alt2_9
Summary:        Creates graphs representing ansible inventory

License:        GPLv3+
URL:            http://github.com/willthames/ansible-inventory-grapher
Source0:        https://github.com/willthames/ansible-inventory-grapher/archive/v%{version}.tar.gz

BuildArch:      noarch

%global _description\
ansible-inventory-grapher creates a dot file suitable for use by graphviz.\

Source44: import.info

%description 
%_description

%if %{with python2}
%package -n python-module-ansible-inventory-grapher
Group: Other
Summary:        %summary
BuildRequires:  python-devel
BuildRequires:  python-module-setuptools
BuildRequires:  ansible
Requires:       ansible
%{?python_provide:%python_provide python2-%{archive_name}}
Provides:       %{archive_name} = %{version}-%{release}
Obsoletes:      %{archive_name} < 2.4.4-2

%description  -n python-module-ansible-inventory-grapher 
%_description
%endif

%package -n python3-module-ansible-inventory-grapher
Group: Other
Summary:        %summary
BuildRequires:  python3-devel
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
BuildRequires:  ansible
Requires:       ansible
%{?python_provide:%python_provide python3-%{archive_name}}
%if ! %{with python2}
Provides:       %{archive_name} = %{version}-%{release}
Obsoletes:      %{archive_name} < 2.4.5-4
%endif

%description  -n python3-module-ansible-inventory-grapher 
%_description

%prep
%setup -q -n %{archive_name}-%{version}


%build
%if %{with python2}
%python_build
%endif
%python3_build

%install
%python3_install

%if %{with python2}
mv %{buildroot}%{_bindir}/%{name} %{buildroot}%{_bindir}/%{name}-3
%python_install
%else
ln -s %{_bindir}/%{name} %{buildroot}%{_bindir}/%{name}-3
%endif


%check
%if %{with python2}
%{__python} setup.py test
%endif
%{__python3} setup.py test

%if %{with python2}
%files -n python-module-ansible-inventory-grapher
%doc README.md
%doc --no-dereference LICENSE.txt
%{_bindir}/%{name}
%{python_sitelibdir_noarch}/%{lib_name}
%{python_sitelibdir_noarch}/ansible_inventory_grapher-%{version}-py2.*.egg-info
%endif

%files -n python3-module-ansible-inventory-grapher
%doc README.md
%doc --no-dereference LICENSE.txt
%if ! %{with python2}
%{_bindir}/%{name}
%endif
%{_bindir}/%{name}-3
%{python3_sitelibdir_noarch}/%{lib_name}
%{python3_sitelibdir_noarch}/ansible_inventory_grapher-%{version}-py3.*.egg-info

%changelog
