Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global debug_package %{nil}
%bcond_without  gui

Name:           ansifilter
Version:        2.18
Release:        alt1_2
Summary:        ANSI terminal escape code converter
License:        GPLv3+
URL:            http://www.andre-simon.de/doku/ansifilter/ansifilter.php
Source0:        http://www.andre-simon.de/zip/%{name}-%{version}.tar.bz2
BuildRequires:  gcc-c++
%if %{with gui}
Source1:        ansifilter.desktop
Source2:        http://www.andre-simon.de/img/af_icon.png
%endif
Source44: import.info

%description
Ansifilter handles text files containing ANSI terminal escape codes. The
command sequences may be stripped or be interpreted to generate formatted
output (HTML, RTF, TeX, LaTeX, BBCode).

%if %{with gui}
%package        gui
Group: Other
Summary:        GUI for %{name} based on Qt5
BuildRequires:  desktop-file-utils
BuildRequires:  qt5-base-devel

%description    gui
Ansifilter handles text files containing ANSI terminal escape codes. The
command sequences may be stripped or be interpreted to generate formatted
output (HTML, RTF, TeX, LaTeX, BBCode).

This is a GUI of %{name} based on Qt5.
%endif

%prep
%setup -q


# Preserve timestamps.
sed -i 's|install -m|install -pm|g' makefile

%if %{with gui}
# Remove pre-configured files which may cause errors during building.
rm -frv src/qt-gui/moc_*.cpp
rm -frv src/qt-gui/Makefile*
%endif

# CRLF quickfix
find . -type f -exec sed -i 's/\r$//' {} + -print

%build
# Upstream embeds the cli code in gui so no need to require cli to use GUI
# program, in order to achieve this we need to preserve the objects with -c.
%make_build CFLAGS+="%{optflags} -c" LDFLAGS="%{?__global_ldflags}"

%if %{with gui}
# %%qmake-qt5 will respect the redhat-rpm-config
%make_build all-gui QMAKE="qmake-qt5"
%endif

%install
%makeinstall_std

%if %{with gui}
make install-gui DESTDIR=%{buildroot}
desktop-file-install --dir=%{buildroot}%{_datadir}/applications %{S:1}
install -pDm644 %{S:2} %{buildroot}%{_datadir}/pixmaps/%{name}.png
%endif

# Use %%doc and %%license to handle docs.
rm -frv %{buildroot}%{_docdir}

%files
%doc ChangeLog* README*
%doc --no-dereference COPYING
%{_bindir}/ansifilter
%{_mandir}/man1/ansifilter.1*

%if %{with gui}
%files gui
%doc ChangeLog* README*
%doc --no-dereference COPYING
%{_bindir}/ansifilter-gui
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/ansifilter.*
%endif

%changelog
