Group: Networking/WWW
%add_findreq_skiplist %_libexecdir/anyterm/anyterm-cmd
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: anyterm
Version: 1.2.3
Release: alt2_19
Summary: A web-based terminal emulator

License: GPLv2+
URL: http://anyterm.org

# The source for this package was pulled from upstream's vcs.  Use the
# following commands to generate the tarball:
#  svn export http://svn.anyterm.org/anyterm/tags/releases/1.2/1.2.3 anyterm-1.2.3
#  tar -jcf anyterm-1.2.3.tar.xz anyterm-1.2.3
Source0: anyterm-1.2.3.tar.xz
Source1: anyterm-cmd
Source4: anyterm.conf
Source5: anyterm.service

# http://anyterm.org/1.1/install.html#secid2252601
Patch0: anyterm-change-url-prefix.patch

BuildRequires:  gcc-c++
BuildRequires: boost-complete  
BuildRequires: zlib-devel
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Source44: import.info


%package httpd
Group: Networking/WWW
Summary: Httpd proxy configuration for anyterm
License: GPLv2+
Requires: %{name} = %{version}-%{release}
Requires: apache2-base apache2-htcacheclean


%description
The Anyterm web-based terminal emulator, permits terminal and/or arbitrary
command access via http. The anyterm daemon can be configured to run any
arbitrary command, redirecting all standard input / output / error to 
and from any javascript-enabled web browser in real time.

%description httpd
The httpd configuration necessary to proxy anyterm.

%prep
%setup -q
%patch0 -p0

%build
export CFLAGS="$RPM_OPT_FLAGS"
export CXXFLAGS="$RPM_OPT_FLAGS -std=c++17"
%make_build CFLAGS="$CFLAGS" CXXFLAGS="$CXXFLAGS" OPTIMISE_FLAGS="$CXXFLAGS"
gzip anytermd.1

%install
install -Dp -m0755 anytermd %{buildroot}%{_sbindir}/anytermd
install -Dp -m0644 anytermd.1.gz %{buildroot}%{_mandir}/man1/anytermd.1.gz
install -Dp -m0755 %{SOURCE1} %{buildroot}%{_libexecdir}/%{name}/anyterm-cmd
install -Dp -m0644 %{SOURCE4} %{buildroot}%{_sysconfdir}/httpd/conf.d/anyterm.conf
install -Dp -m0644 %{SOURCE5} %{buildroot}%{_unitdir}/anyterm.service

mkdir -p %{buildroot}%{_datadir}/anyterm/
for f in browser/*.{html,css,js,png,gif}; do
   install -m644 "$f" %{buildroot}%{_datadir}/anyterm/
done

# Create a home directory for the user.
mkdir -p -m755 %{buildroot}%{_localstatedir}/run/%{name}
mkdir -p %{buildroot}%{_sysconfdir}/tmpfiles.d
cat <<EOF > %{buildroot}%{_sysconfdir}/tmpfiles.d/%{name}.conf
d %{_localstatedir}/run/%{name} 0755 root %{name}
EOF
for rpm404_ghost in %{_localstatedir}/run/%{name}
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done



%pre
getent group %{name} >/dev/null 2>&1 || \
   groupadd -r %{name}
getent passwd %{name} >/dev/null 2>&1 || \
  useradd -r -l -g %{name} -s /sbin/nologin \
  -d %{_localstatedir}/run/%{name} -c "Anyterm service" %{name}
if [[ ! -d %{_localstatedir}/run/%{name} ]]; then
  mkdir -m755 %{_localstatedir}/run/%{name}
  chown %{name}:%{name} %{_localstatedir}/run/%{name}
fi
if [[ $(getent passwd %{name} | cut -d: -f6) == /dev/null ]]; then
  usermod -d %{_localstatedir}/run/%{name} %{name}
fi
exit 0

%post
%post_service anyterm

%preun
%preun_service anyterm

%files
%{_sbindir}/anytermd
%{_libexecdir}/anyterm/
%{_mandir}/man1/anytermd.1*
%{_datadir}/anyterm/
%{_unitdir}/anyterm.service
%ghost %attr(0755,%{name},%{name}) %dir %{_localstatedir}/run/%{name}
%{_sysconfdir}/tmpfiles.d/%{name}.conf
%doc LICENSE

%files httpd
%config(noreplace) %{_sysconfdir}/httpd/conf.d/anyterm.conf

%changelog
