Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commit ed74fbc05c007696b31db207d44af1372067ccf9

Name:           api-sanity-checker
Version:        1.98.7
Release:        alt2_20
Summary:        An automatic generator of basic unit tests for a shared C/C++ library

License:        GPL-2.0
URL:            http://forge.ispras.ru/projects/api-sanity-autotest
# https://github.com/lvc/api-sanity-checker/archive/%%{version}.tar.gz
Source0:        %{name}-%{version}.tar.gz

BuildArch:      noarch
BuildRequires:  abi-compliance-checker >= 1.98.7
BuildRequires:  coreutils
BuildRequires:  help2man
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  sed
Requires:       abi-compliance-checker >= 1.98.7
Requires:       binutils


Source44: import.info

%description
API Sanity Checker (ASC) is an automatic generator of basic unit tests for
shared C/C++ libraries. It is able to generate reasonable (in most, but
unfortunately not all, cases) input data for parameters and compose simple
("sanity" or "shallow"-quality) test cases for every function in the API through
the analysis of declarations in header files. The quality of generated tests
allows to check absence of critical errors in simple use cases. The tool is able
to build and execute generated tests and detect crashes (segfaults), aborts, all
kinds of emitted signals, non-zero program return code and program hanging. It
may be considered as a tool for out-of-the-box low-cost sanity checking
(fuzzing) of the library API or as a test development framework for initial
generation of templates for advanced tests. Also it supports universal format of
tests, random test generation mode, specialized data types and other useful
features.


%prep
%setup -q

chmod -x LICENSE


%build
# Nothing to build.


%install
mkdir -p %{buildroot}%{_bindir}
perl ./Makefile.pl -install --destdir=%{buildroot} --prefix=%{_prefix}

# Create a man page.
mkdir -p %{buildroot}%{_mandir}/man1
help2man -h --info -o %{buildroot}%{_mandir}/man1/api-sanity-checker.1 \
         -N %{buildroot}%{_bindir}/api-sanity-checker
sed -i 's|API(1)|API-SANITY-CHECKER(1)|g' %{buildroot}%{_mandir}/man1/api-sanity-checker.1
sed -i '3,5d' %{buildroot}%{_mandir}/man1/api-sanity-checker.1


%files
%doc --no-dereference LICENSE
%doc README doc/*
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*
%{_datadir}/%{name}


%changelog
