Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires: libcrypt-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define uprel 15
Name: aprsd
Summary: Internet gateway and client access to amateur radio APRS packet data
Version: 2.2.5
Release: alt4_%{uprel}.6.32
License: GPLv2+
Source0: http://downloads.sourceforge.net/%{name}/%{name}-%{version}-%{uprel}.tar.gz
Source1: aprsd.conf
Source2: aprsd.service
Source3: INIT.TNC
Source4: user.deny
Source5: welcome.txt
Source6: RESTORE.TNC
Source7: aprsd.logrotate
Patch0: aprsd-2.2.5-15-compile.patch
Patch1: aprsd-2.2.5-15-gcc43-port.patch
Patch2: aprsd-2.2.5-15-sysconfdir.patch
Patch3: aprsd-configure-c99.patch
URL: http://sourceforge.net/projects/aprsd/
BuildRequires:  gcc-c++
BuildRequires: libax25-devel
Source44: import.info
#Requires (preun): /sbin/chkconfig
#Requires (preun): /sbin/service
#Requires (post): /sbin/chkconfig


%description
APRSd is an APRS server program that uses amateur radio and internet
services to convey GPS mapping, weather, and positional data.
It has been developed by and for amateur radio enthusiasts to provide
real-time data in an easy to use package.

%prep
%setup -q -n %{name}-%{version}-%{uprel}
%patch0 -p1 -b compile
%patch1 -p1 -b gccport
%patch2 -p1 -b sysconfdir
%patch3 -p1 -b configure-c99

%build
export CXXFLAGS="-std=c++14 $RPM_OPT_FLAGS"
%configure
%make_build

%install
make install DESTDIR="%{buildroot}" INSTALL="install -p"
mkdir -p %{buildroot}%{_sysconfdir}
mkdir -p %{buildroot}%{_sysconfdir}/aprsd
mkdir -p %{buildroot}%{_unitdir}
mkdir -p %{buildroot}%{_sysconfdir}/logrotate.d
install -m 644 %{SOURCE1} %{buildroot}%{_sysconfdir}/aprsd/aprsd.conf
install -m 755 %{SOURCE2} %{buildroot}%{_unitdir}/aprsd.service
install -m 644 %{SOURCE3} %{buildroot}%{_sysconfdir}/aprsd/INIT.TNC
install -m 644 %{SOURCE4} %{buildroot}%{_sysconfdir}/aprsd/user.deny
install -m 644 %{SOURCE5} %{buildroot}%{_sysconfdir}/aprsd/welcome.txt
install -m 644 %{SOURCE6} %{buildroot}%{_sysconfdir}/aprsd/RESTORE.TNC
install -m 644 %{SOURCE7} %{buildroot}%{_sysconfdir}/logrotate.d/aprsd
mkdir -p %{buildroot}%{_localstatedir}
mkdir -p %{buildroot}%{_localstatedir}/log/aprsd

%post
if [ $1 -eq 1 ] ; then 
    # Initial installation 
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi


%preun
if [ $1 -eq 0 ] ; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable aprsd.service > /dev/null 2>&1 || :
    /bin/systemctl stop aprsd.service > /dev/null 2>&1 || :
fi

%postun
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then
    # Package upgrade, not uninstall
    /bin/systemctl try-restart aprsd.service >/dev/null 2>&1 || :
fi

%files
%{_bindir}/aprsd
%{_bindir}/aprspass
%{_unitdir}/aprsd.service
%dir %{_sysconfdir}/aprsd
%dir %{_localstatedir}/log/aprsd
%config(noreplace) %{_sysconfdir}/aprsd/*
%config(noreplace) %{_sysconfdir}/logrotate.d/aprsd
%doc AUTHORS
%doc COPYING
%doc ChangeLog
%doc README
%doc doc/aprsddoc.html
%doc doc/ports.html
%doc doc/q.html
%doc doc/qalgorithm.html

%changelog
