Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           arcem
Version:        1.50.2
Release:        alt2_15
Summary:        Highly portable Acorn Archimedes emulator

License:        GPLv2+
URL:            http://arcem.sourceforge.net
Source0:        http://downloads.sourceforge.net/%{name}/%{name}-%{version}-src.zip
# ARMLinux Rom Image - kernel v2.2
Source1:        http://arcem.sourceforge.net/linuxrom.zip
# Wrapper script
Source2:        %{name}.sh
# RPM Fusion README
Source3:        README_%{name}.Fedora
# User manual
Source4:        http://arcem.sourceforge.net/manual/%{name}-1.50.html
Source5:        %{name}.desktop
# Appdata by Richard Hughes
# http://sourceforge.net/p/arcem/bugs/18/
Source6:        %{name}.appdata.xml
# Makefile patch
Patch0:         %{name}-1.50-Makefile.patch

BuildRequires:  gcc
BuildRequires:  libX11-devel
BuildRequires:  libXext-devel
BuildRequires:  libicns-utils
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  desktop-file-utils
Requires:       icon-theme-hicolor
Source44: import.info

%description
ArcEm is a Acorn Archimedes A400 hardware emulator that is highly portable. As
it's a hardware emulator it's capable of running multiple operating systems
including RISC OS 3.XX and ARM Linux. ArcEm requires either a RISC OS 3.XX or
ARM Linux ROM to fully function. Only the Linux ROM can be legally included.


%prep
%setup -qn %{name}-src
# Makefile is heavily patched because it's largely broken in many ways
%patch0 -p1
unzip -qq %{SOURCE1}

# Place the user manual
install -pm0644 %{SOURCE4} manual.html 

# Place RPM Fusion README
install -pm0644 %{SOURCE3} .

# Fix premissions
chmod 644 docs/*
find . -type f -name "*.h" -exec chmod 644 {} \;
find . -type f -name "*.c" -exec chmod 644 {} \;


%build

%make_build SOUND_SUPPORT=yes


%install
make install INSTALL_DIR=%{buildroot} prefix=%{_prefix}

# Install default configuration file
mkdir -p %{buildroot}%{_datadir}/%{name}
install -pm0644 arcemrc %{buildroot}%{_datadir}/%{name}

# Install ARMLinux Rom Image
mkdir -p %{buildroot}%{_datadir}/%{name}/linuxrom
install -pm0644 ROM.linux %{buildroot}%{_datadir}/%{name}/linuxrom/ROM

# Install modules
mkdir -p %{buildroot}%{_datadir}/%{name}/modules
install -pm0644 support_modules/*/*,ffa %{buildroot}%{_datadir}/%{name}/modules

# Install wrapper script
mv %{buildroot}%{_bindir}/%{name} %{buildroot}%{_bindir}/%{name}.bin
install -pm0755 %{SOURCE2} %{buildroot}%{_bindir}/%{name}

# Extract Mac OS X icons
icns2png -x macosx/%{name}.icns 

# Install icons
for i in 128; do
  install -d -m 755 %{buildroot}%{_datadir}/icons/hicolor/${i}x${i}/apps
  install -m 644 %{name}_${i}x${i}x32.png \
    %{buildroot}%{_datadir}/icons/hicolor/${i}x${i}/apps/%{name}.png
done

# Install desktop file
install -d %{buildroot}%{_datadir}/applications
desktop-file-install \
  --dir %{buildroot}%{_datadir}/applications \
  %{SOURCE5}

# Install appdata
install -d %{buildroot}%{_metainfodir}
install -p -m 0644 %{SOURCE6} %{buildroot}%{_metainfodir}
appstream-util validate-relax --nonet \
  %{buildroot}%{_metainfodir}/%{name}.appdata.xml


%files
%{_bindir}/%{name}
%{_bindir}/%{name}.bin
%{_datadir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.png
%{_metainfodir}/%{name}.appdata.xml
%doc docs/5thColumn.txt manual.html README_arcem.Fedora
%doc --no-dereference docs/COPYING


%changelog
