Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: argbash
Version: 2.10.0
Release: alt1_3
Summary: Bash argument parsing code generator
License: BSD
URL: https://argbash.io
Source0: https://github.com/matejak/%{name}/archive/%{version}/%{name}-%{version}.tar.gz

BuildArch: noarch

BuildRequires: autoconf
BuildRequires: coreutils
BuildRequires: bash sh
BuildRequires: bash-completion
BuildRequires: python3-module-docutils

%if 0%{?fedora} >= 27
BuildRequires: shellcheck
%endif

Requires: autoconf
Requires: bash sh
Requires: coreutils
Requires: grep
Requires: sed

%if !0%{?rhel} || 0%{?rhel} > 7
Requires: bash-completion
%endif
Source44: import.info

%description
Argbash helps your shell scripts to accept arguments.
You declare what arguments you want your script to accept and Argbash
generates the shell code that parses them from the command-line and exposes
passed values as shell variables.

Help message is also generated, and helpful error messages are dispatched
if the script is called with arguments that conflict with the interface.

%prep
%setup -q


%build

%install
cd resources && \
    ROOT=%{buildroot} \
    PREFIX=%{_prefix} \
    PREFIXED_LIBDIR=%{_datarootdir} \
    SYSCONFDIR=%{_sysconfdir} \
    INSTALL_COMPLETION=yes \
    BASH_COMPLETION_DIRECTORY=%{_datarootdir}/bash-completion/completions \
    make install

%check
#cd resources && make check

%files
%doc --no-dereference LICENSE
%doc README.md ChangeLog
%{_mandir}/man1/argbash*

%{_bindir}/argbash
%{_bindir}/argbash-1to2
%{_bindir}/argbash-init
%{_datarootdir}/argbash/
%{_datarootdir}/bash-completion/completions/argbash

%changelog
