Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           arptools
Summary:        Collection of libnet and libpcap based ARP utilities
License:        GPL-2.0-or-later

%global git_commit_full 2cf523f6fe6760da1eb3f97963f1975f96f6f106
%global git_commit %(c="%{git_commit_full}"; echo "${c:0:7}")
%global git_date 20230218

Version:        1.0.2
Release:        alt2_24.%{git_date}git%{git_commit}

URL:            https://github.com/burghardt/arptools
Source0:        https://github.com/burghardt/arptools/archive/%{git_commit_full}/%{name}-%{git_commit_full}.tar.gz

BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  gcc
BuildRequires:  libnet2-devel
BuildRequires:  libpcap-devel
Source44: import.info


%description
ARP Tools is collection of libnet and libpcap based ARP utilities.
It currently contains ARP Discover (arpdiscover), an Ethernet scanner based on
ARP protocol; ARP Flood (arpflood), an ARP request flooder; and ARP Poison
(arppoison), for poisoning switches' MAC address tables.


%prep
%setup -q -n %{name}-%{git_commit_full}


%build
chmod +x autogen.sh # yes, really
NOCONFIGURE="yes" ./autogen.sh
%configure
%make_build


%install
%makeinstall_std


%files
%doc AUTHORS ChangeLog NEWS README.md TODO
%doc --no-dereference COPYING
%{_sbindir}/arpdiscover
%{_sbindir}/arpflood
%{_sbindir}/arppoison


%changelog
