# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This should be pushed to nonfree because atomiks reuses the level design and graphics
# of the original Atomix game (with permission of the authors but not under a FLOSS license).

Name:           atomiks
Version:        1.0.4.1
Release:        alt1_5
Summary:        A remake of the classic Atomix game for modern platforms
Group:          Games/Puzzles
License:        GPLv3+ and Nonfree
Url:            http://atomiks.sourceforge.net/
Source0:        https://downloads.sf.net/atomiks/%{name}-%{version}.tar.gz

BuildRequires:  dos2unix
BuildRequires:  icoutils icoutils-extra
BuildRequires:  pkgconfig(libmikmod)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_mixer)
BuildRequires:  pkgconfig(zlib)
Source44: import.info

%description
Atomiks is a faithful remake of, and a tribute to, Atomix, a classic puzzle
game created by Softtouch & RoSt and published in 1990 by the Thalion
Software company. Atomiks is free software, and shares no code with
the original Atomix game.

The Atomiks engine is released under the GNU GPL license, although this
license does NOT apply to level design and graphics used by Atomiks, since
these remain the intellectual property of their authors, Softtouch & RoSt.

%prep
%setup -q
dos2unix readme.txt license.txt history.txt

# fix empty debugsourcefiles
sed -i 's|CFLAGS =|CFLAGS+=|' Makefile

%build

%make_build

%install
install -D -m755 %{name} %{buildroot}%{_gamesbindir}/%{name}

# Icon
install -d %{buildroot}%{_iconsdir}/hicolor/64x64/apps
icotool -x %{name}.ico -o %{buildroot}%{_iconsdir}/hicolor/64x64/apps/%{name}.png

# Menu entry
install -d %{buildroot}%{_datadir}/applications/
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=Atomiks
Comment=Remake and tribute to Atomix
Exec=%{name}
Icon=%{name}
Type=Application
Categories=Game;LogicGame;
EOF

%files
%doc readme.txt license.txt history.txt atomiks-softtouch\ agreement.png
%{_gamesbindir}/atomiks
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/64x64/apps/%{name}.png


%changelog
