# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		auralquiz
Version:	1.0.0
Release:	alt1_6
Summary:	A simple music quiz game for GNU/Linux
License:	GPLv2+
Group:		Games/Other
URL:		https://jancoding.wordpress.com/auralquiz/
Source0:	https://download.savannah.gnu.org/releases/auralquiz/%{name}-v%{version}.tar.gz
Patch0:		auralquiz-v1.0.0-linking.patch

BuildRequires:	qt5-designer qt5-tools
BuildRequires:	pkgconfig(Qt5Core)
BuildRequires:	pkgconfig(Qt5Gui)
BuildRequires:	pkgconfig(Qt5Network)
BuildRequires:	pkgconfig(Qt5Widgets)
BuildRequires:	pkgconfig(phonon4qt5)
BuildRequires:	pkgconfig(taglib)

Requires:	libqt5-gui libqt5-network
Requires:	qt5-phonon-backend-3-vlc
Source44: import.info

%description
The game plays short pieces of music files from the player's chosen
folders, and presents a question and several answers about
the current song.
The fastest the answer, the more points the player receives. Up to
8 people can play, in a turn-based mode.
The game is quite complete already, but there are more modes
to be added, and several rough edges to polish.
Auralquiz uses Phonon for sound output.

%prep
%setup -q -n %{name}-v%{version}
%patch0 -p1


# generate French translation file
%{_qt5_bindir}/lrelease translations/auralquiz_fr.ts

%build
%qmake_qt5

%make_build

%install
%makeinstall_std INSTALL_ROOT=%{buildroot}

%files
%doc CHANGELOG README TRANSLATING
%doc LICENSE
%{_gamesbindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}.png
%{_mandir}/man6/%{name}.6*


%changelog
