# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global __requires_exclude typelib\\(Unity\\)

Name:           autokey
Version:        0.96.0
Release:        alt1_1
Summary:        Desktop automation utility

Group:          Graphical desktop/Other
License:        GPLv3
URL:            https://github.com/autokey/autokey
Source0:        https://github.com/autokey/autokey/archive/v%{version}/%{name}-%{version}.tar.gz
Patch1:         0001-Port-to-Ayatana-AppIndicator.patch

BuildArch:      noarch
BuildRequires:  pkgconfig(python3)
BuildRequires:  python3-module-xlib
BuildRequires:  python3-module-pyinotify
BuildRequires:  python3-module-dbus python3-module-dbus-gobject
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
BuildRequires:  python3-module-PyQt5-devel
BuildRequires:  python3-module-qscintilla2-qt5

Requires:       python3-module-pyinotify
Provides:       autokey = %{version}-%{release}
Provides:       autokey-common = %{version}-%{release}
Provides:       autokey-gtk = %{version}-%{release}
Source44: import.info


%description
AutoKey is a desktop automation utility for Linux and X11. It allows
the automation of virtually any task by responding to typed abbreviations
and hot keys. It offers a full-featured GUI that makes it highly
accessible for novices, as well as a scripting interface offering
the full flexibility and power of the Python language.

%package common
Summary:        Desktop automation utility - common data
Group:          Graphical desktop/Other
Requires:       python3-module-dbus python3-module-dbus-gobject
Requires:       python3-module-pyinotify
Requires:       python3-module-xlib
Requires:       wmctrl
Provides:       autokey = %{version}-%{release}


%description common
This package contains the common data shared between the various front ends.


%package gtk
Summary:        AutoKey GTK+ front end
Group:          Graphical desktop/Other
Requires:       python3-module-pygobject3 python3-module-pygobject3-pygtkcompat
Requires:       zenity
Requires:       autokey-common = %{version}-%{release}
Provides:       autokey = %{version}-%{release}

%description gtk
This package contains the GTK+ front end for autokey.


%package qt
Summary:        AutoKey Qt front end
Group:          Graphical desktop/Other
Requires:       python3-module-PyQt5
Requires:       python3-module-qscintilla2-qt5
Requires:       autokey-common = %{version}-%{release}
Provides:       autokey = %{version}-%{release}

%description qt
This package contains the Qt front end for autokey.


%prep
%setup -q
%patch1 -p1


%build
%python3_build


%install
%python3_install

# remove shebang from python libraries
for lib in $(find %{buildroot}%{python3_sitelibdir_noarch}/autokey/ -name "*.py"); do
 sed '/\/usr\/bin\/env/d' $lib > $lib.new &&
 touch -r $lib $lib.new &&
 mv $lib.new $lib
done

# ensure pkg_resources is able to find the required python packages
sed -i 's/python3-xlib/python-xlib/' %{buildroot}%{python3_sitelibdir_noarch}/%{name}-%{version}-py%{__python3_version}.egg-info/requires.txt

%files common
%doc ACKNOWLEDGMENTS README.rst new_features.rst CHANGELOG.rst
%dir %{python3_sitelibdir_noarch}/autokey
%{python3_sitelibdir_noarch}/autokey/*.py*
%{python3_sitelibdir_noarch}/autokey-*.egg-info
%{python3_sitelibdir_noarch}/autokey/__pycache__/
%{python3_sitelibdir_noarch}/autokey/configmanager/
%{python3_sitelibdir_noarch}/autokey/iomediator/
%{python3_sitelibdir_noarch}/autokey/model/
%{python3_sitelibdir_noarch}/autokey/scripting/
%exclude %{python3_sitelibdir_noarch}/autokey/gtkapp.py*
%exclude %{python3_sitelibdir_noarch}/autokey/gtkui/
%exclude %{python3_sitelibdir_noarch}/autokey/__pycache__/gtkapp.*
%exclude %{python3_sitelibdir_noarch}/autokey/qtapp.py*
%exclude %{python3_sitelibdir_noarch}/autokey/qtui/
%exclude %{python3_sitelibdir_noarch}/autokey/__pycache__/qtapp.*
%{_datadir}/icons/hicolor/scalable/apps/autokey-status*.svg
%{_datadir}/icons/hicolor/*/apps/autokey.png
%{_datadir}/icons/hicolor/scalable/apps/autokey.svg
%{_datadir}/icons/ubuntu-mono-dark/apps/*
%{_datadir}/icons/ubuntu-mono-light/apps/*
%{_datadir}/icons/Humanity/scalable/apps/*.svg
%{_bindir}/autokey-run
%{_bindir}/autokey-shell
%{_mandir}/man1/autokey-run.1*

%files gtk
%{_bindir}/autokey-gtk
%{python3_sitelibdir_noarch}/autokey/gtkapp.py*
%{python3_sitelibdir_noarch}/autokey/gtkui/
%{python3_sitelibdir_noarch}/autokey/__pycache__/gtkapp.*
%{_datadir}/applications/autokey-gtk.desktop
%{_mandir}/man1/autokey-gtk.1*

%files qt
%{_bindir}/autokey-qt
%{python3_sitelibdir_noarch}/autokey/qtapp.py*
%{python3_sitelibdir_noarch}/autokey/qtui/
%{python3_sitelibdir_noarch}/autokey/__pycache__/qtapp.*
%{_datadir}/applications/autokey-qt.desktop
%{_mandir}/man1/autokey-qt.1*


%changelog
