Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 8

Name:       bcal
Version:    2.4
Release:    alt1_%autorelease
Summary:    Storage conversion and expression calculator

License:    GPL-3.0-or-later
URL:        https://github.com/jarun/bcal
Source0:    https://github.com/jarun/bcal/archive/v%{version}/%{name}-%{version}.tar.gz

# Only available for 64bits system
ExclusiveArch: x86_64 aarch64 ia64 ppc64 ppc64le s390x riscv64

BuildRequires:  gcc
BuildRequires:  libreadline-devel
Source44: import.info

%description
bcal (Byte CALculator) is a command-line utility for storage conversions
and calculations. Storage, hardware and firmware developers work
with numerical calculations regularly e.g., storage unit conversions,
address calculations etc. If you are one and can't calculate the hex address
offset for (512 - 16) MiB immediately, or the value when the 43rd bit of
a 64-bit address is set, bcal is for you

%prep
%setup -q -n %{name}-%{version}

sed -i '/STRIP ?= strip/d;s/install: bcal/install: /;s/$(CFLAGS)/$(CFLAGS) $(LDFLAGS)/' Makefile

%build
export CFLAGS="-fPIC %{optflags}"
export LDFLAGS="%{?__global_ldflags}"
%make_build bcal

%install
%makeinstall_std PREFIX=%{_prefix}

%files
%doc CHANGELOG README.md
%doc --no-dereference LICENSE
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*

%changelog
