# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define rel     5
%define date    20130311
%define daterel 1

Name:           beret
Version:        1.2.1
Release:        alt1_%{rel}.%{date}.%{daterel}
Summary:        2D puzzle-platformer starring a telekinetic scientist
Group:          Games/Puzzles
License:        LGPLv2
Url:            http://kiwisauce.com/beret
# Source retrieved from https://gitorious.org/beret/beret
Source0:        %{name}-%{version}+%{date}.tar.xz
Patch0:         beret-1.2.1-mga-libmath-and-flags.patch
Patch1:         beret-1.2.1-mga-resource-and-config-paths.patch

BuildRequires:  icoutils
BuildRequires:  pkgconfig(sdl)
BuildRequires:  pkgconfig(SDL_image)
BuildRequires:  pkgconfig(SDL_mixer)
BuildRequires:  pkgconfig(SDL_ttf)
Requires:       %{name}-data >= %{version}-%{release}
Source44: import.info

%description
Beret is a 2D puzzle-platformer game about a scientist named Beret
who has gained telekinetic abilities through his research at the Evil
Corporation. He decides that the Evil Corporation is too evil for his
liking, and begins his solitary quest to overthrow the corporation
and punish the evil deeds of his employers.

%package data
Group: Games/Puzzles
Summary:        Data files for the Beret game
BuildArch:      noarch

%description data
This package contains arch-independent data needed by the game Beret,
whose binary is shipped in the %{name} package.

%prep
%setup -q -n %{name}-%{version}+%{date}
%patch0 -p1
%patch1 -p1


%build
%make_build OPTFLAGS="%{optflags}" LDFLAGS=""

%install
install -D -m755 %{name} %{buildroot}%{_gamesbindir}/%{name}

install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a images music rooms sfx AveriaSans-Regular.ttf \
    %{buildroot}%{_gamesdatadir}/%{name}

install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Beret
GenericName=Puzzle platformer
Comment=%{summary}
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;LogicGame;
EOF

icotool -x images/icon.ico
install -D -m644 icon_3_32x32x8.png %{buildroot}%{_iconsdir}/hicolor/48x48/apps/%{name}.png

%files
%{_gamesbindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/48x48/apps/%{name}.png

%files data
%{_gamesdatadir}/%{name}/


%changelog
