Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate gcc-c++ qt5-base-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           berry
Version:        1.0.0
Release:        alt2_19
Summary:        Modern and light image viewer

# The entire source code is GPLv3+
# except the following files in
# asemantools/qml/AsemanTools/Controls/Styles/Desktop/ which are BSD
# CalendarStyle.qml, FocusFrameStyle.qml, MenuBarStyle.qml, SliderStyle.qml
# StatusBarStyle.qml, TableViewStyle.qml, TextAreaStyle.qml, ToolBarStyle.qml

License:        GPLv3+ and BSD
Url:            http://aseman.co/en/products/berry
Source0:        http://aseman.co/downloads/berry/1/%{name}-%{version}-src.tar.gz
# https://github.com/Aseman-Land/Berry/issues/9
Source1:        %{name}.appdata.xml
# For a breakdown of the licensing, see PACKAGE-LICENSING
Source2:        %{name}-PACKAGE-LICENSING

# PATCH-FIX-OPENSUSE install.patch avvissu@yandex.ru -- Changed the paths install files
Patch0:         berry-1.0.0_install.patch
# PATCH-FIX-UPSTREAM qt5-5.5.patch avvissu@yandex.ru -- Fix build with Qt5 >= 5.5
Patch1:         berry-1.0.0_qt5-5.5.patch

BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  icon-theme-hicolor
BuildRequires:  desktop-file-utils
BuildRequires:  chrpath
BuildRequires:  pkgconfig(Qt5Core) >= 5.2.0
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Multimedia)
BuildRequires:  pkgconfig(Qt5Network)
BuildRequires:  pkgconfig(Qt5Qml)
BuildRequires:  pkgconfig(Qt5Script)
BuildRequires:  pkgconfig(exiv2)
Source44: import.info

%description
Berry is a modern and new image viewer which is focusing on User interface.
Berry is trying to provide an easy to use and touch screen compatible user
interface.

%prep
%setup -q -n %{name}
%patch0 -p1
%patch1 -p1
cp -p %{SOURCE2} .

# fixes W: spurious-executable-perm
find . -type f  \( -name "*.cpp" -o -name "*.h" \) -exec chmod a-x {} \;

rm -rf debian

%build
mkdir build
pushd build
%qmake_qt5 ../Berry.pro
%make_build
popd

%install
pushd build
%makeinstall_std INSTALL_ROOT=%{buildroot}
# Remove rpath
chrpath --delete %{buildroot}%{_bindir}/%{name}
popd

install -Dp -m 644 %{SOURCE1} %{buildroot}/%{_datadir}/appdata/%{name}.appdata.xml

find %{buildroot}%{_datadir}/%{name}/files/translations -name "*.qm" | sed 's:'%{buildroot}'::
s:.*/\([a-zA-Z]\{2\}\).qm:%lang(\1) \0:' > %{name}.lang

%check
desktop-file-validate %{buildroot}%{_datadir}/applications/*.desktop
appstream-util validate-relax --nonet %{buildroot}/%{_datadir}/appdata/%{name}.appdata.xml

%files -f %{name}.lang
%doc --no-dereference LICENSE LICENSE.html %{name}-PACKAGE-LICENSING
%doc README.md
%{_bindir}/%{name}
%{_datadir}/applications/Berry.desktop
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg
%{_datadir}/mime/application/%{name}-lock.xml
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/files
%dir %{_datadir}/%{name}/files/translations

%changelog
