Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/bison /usr/bin/curl /usr/bin/valgrind libcurl-devel libopenjpeg2.0-devel libossp-uuid-devel python3-devel
# END SourceDeps(oneline)
BuildRequires: chrpath
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name bes
%global bescachedir %{_localstatedir}/cache/%{name}
%global bespkidir %{_sysconfdir}/pki/%{name}
%global beslogdir %{_localstatedir}/log/%{name}
%global besuser %{name}
%global besgroup %{name}

%global commit 20781c060611626c4fbf9788510fd8a5794a2dcc

Name:           bes
Version:        3.20.13
Release:        alt1_11
Summary:        Back-end server software framework for OPeNDAP

License:        LGPLv2+
URL:            https://github.com/OPENDAP/bes
Source0:        http://www.opendap.org/pub/source/bes-%{version}.tar.gz
Source1:        bes.service
# Fix link
Patch1:         bes-link.patch
# Use int32 type
Patch2:         bes-int32.patch
# Fix configure test compromised by LTO
Patch3:		bes-config.patch
Patch4: bes-c99.patch

BuildRequires:  gcc-c++
# For autoreconf
BuildRequires:  libtool
BuildRequires:  libdap-devel >= 3.20.10
BuildRequires:  bzlib-devel
BuildRequires:  libtirpc-devel
BuildRequires:  libuuid-devel
BuildRequires:  libreadline-devel
BuildRequires:  zlib-devel
# needed by ppt
BuildRequires:  libssl-devel
BuildRequires:  doxygen graphviz libgraphviz
BuildRequires:  libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
# For modules
BuildRequires:  libcfitsio-devel
# swath2grid with gdal currently fails to build
BuildRequires:  libgdal-devel
BuildRequires:  hdf-static
BuildRequires:  hdf5-tools libhdf5-devel
BuildRequires:  icu-utils libicu-devel
BuildRequires:  libnetcdf-devel
# For tests
BuildRequires:  cppunit-devel
# To remove rpath due to https://github.com/OPENDAP/bes/issues/565
BuildRequires:  chrpath

Requires(pre): shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-submap shadow-utils
# Don't provide modules
%global __provides_exclude_from ^%{_libdir}/bes/.*\\.so$


# Obsolete the separate handlers
Obsoletes:      dap-freeform_handler < 3.8.8-3
Provides:       dap-freeform_handler = 3.8.8-3
Obsoletes:      dap-hdf4_handler < 3.11.5-3
Provides:       dap-hdf4_handler = 3.11.5-3
Obsoletes:      dap-netcdf_handler < 3.10.4-3
Provides:       dap-netcdf_handler = 3.10.4-3
Obsoletes:      dap-server < 4.1.6-3
Provides:       dap-server = 4.1.6-3
Source44: import.info
%filter_from_requires /^libdap_module\\.so.*$/d
Patch33: bes-3.17.0-alt-as-needed.patch

%description
BES is a high-performance back-end server software framework for 
OPeNDAP that allows data providers more flexibility in providing end 
users views of their data. The current OPeNDAP data objects (DAS, DDS, 
and DataDDS) are still supported, but now data providers can add new data 
views, provide new functionality, and new features to their end users 
through the BES modular design. Providers can add new data handlers, new 
data objects/views, the ability to define views with constraints and 
aggregation, the ability to add reporting mechanisms, initialization 
hooks, and more.


%package        devel
Group: Other
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}
# for the /usr/share/aclocal directory ownership
Requires:       automake
Requires:       pkgconfig

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%package doc
Group: Other
Summary: Documentation of the OPeNDAP BES
BuildArch: noarch

%description doc
Documentation of OPeNDAP BES.


%prep
%setup -q -n bes-%{version}
%patch1 -p1 -b .link
%patch2 -p1 -b .int32
%patch3 -p1 -b .config
%patch33 -p1
%patch4 -p1

# Fixes rpaths
autoreconf --install
chmod a-x dispatch/BESStreamResponseHandler*

%build
autoreconf -fisv
# We need to enable static builds so it can link against libdap_module.a
%configure --disable-dependency-tracking \
  --with-cfits-inc=%{_includedir} --with-cfits-libdir=%{_libdir} \
  CPPFLAGS="-I%{_includedir}/cfitsio -I%{_includedir}/tirpc" LDFLAGS=-L%{_libdir}/libdap LIBS=-ltirpc
# This fails currently: --without-dap-modules
%make_build

make docs
rm -rf __distribution_docs
cp -pr docs __distribution_docs
chmod a-x __distribution_docs/BES_*.doc
mv html __distribution_docs/api-html
# .map and .md5 files are of dubious use
find \( -name \*.map -o -name \*.md5 \) -delete

sed -i.dist -e 's:=/tmp:=%{bescachedir}:' \
  -e 's:=.*/bes.log:=%{beslogdir}/bes.log:' \
  -e 's:=/full/path/to/serverside/certificate/file.pem:=%{bespkidir}/cacerts/file.pem:' \
  -e 's:=/full/path/to/serverside/key/file.pem:=%{bespkidir}/public/file.pem:' \
  -e 's:=/full/path/to/clientside/certificate/file.pem:=%{bespkidir}/cacerts/file.pem:' \
  -e 's:=/full/path/to/clientside/key/file.pem:=%{bespkidir}/public/file.pem:' \
  -e 's:=user_name:=%{besuser}:' \
  -e 's:=group_name:=%{besgroup}:' \
  dispatch/bes/bes.conf

%install
%makeinstall_std
find $RPM_BUILD_ROOT \( -name '*.la' -o -name '*.a' \) -exec rm -f {} ';'
mkdir -p $RPM_BUILD_ROOT%{bescachedir}
mkdir -p $RPM_BUILD_ROOT%{bespkidir}/{cacerts,public}
mkdir -p $RPM_BUILD_ROOT%{beslogdir}
mv $RPM_BUILD_ROOT%{_bindir}/bes-config-pkgconfig $RPM_BUILD_ROOT%{_bindir}/bes-config
# Use systemd instead
rm -r ${RPM_BUILD_ROOT}/etc/rc.d
mkdir -p $RPM_BUILD_ROOT%{_unitdir}
cp -p %SOURCE1 $RPM_BUILD_ROOT%{_unitdir}/bes.service
mkdir -p $RPM_BUILD_ROOT%{_tmpfilesdir}
mv $RPM_BUILD_ROOT%{_bindir}/bes-tmpfiles-conf $RPM_BUILD_ROOT%{_tmpfilesdir}/%{name}.conf
chrpath -d $RPM_BUILD_ROOT%{_bindir}/build_dmrpp
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done


%check
make check || cat modules/*_handler/bes-testsuite/*.log || cat */tests/*.log || cat */unit-tests/test-suite.log


%pre
getent group %{besgroup} >/dev/null || groupadd -r %{besgroup}
getent passwd %{besuser} >/dev/null || \
useradd -r -g %{besuser} -d %{beslogdir} -s /sbin/nologin \
    -c "BES daemon" %{besuser}
exit 0

%post
%post_service bes

%preun
%preun_service bes

%files
%doc --no-dereference COPYING
%doc ChangeLog NEWS README.md
%dir %{_sysconfdir}/bes/
%config(noreplace) %{_sysconfdir}/bes/bes.conf
%config(noreplace) %{_sysconfdir}/bes/site.conf.proto
%config(noreplace) %{_sysconfdir}/bes/modules/
%config(noreplace) %{_sysconfdir}/logrotate.d/*
%{_unitdir}/bes.service
%{_tmpfilesdir}/bes.conf
%dir %{_datadir}/bes
%{_datadir}/bes/*.html
%{_datadir}/bes/*.txt
%{_datadir}/bes/*.xml
%{_datadir}/hyrax/
%{_bindir}/bescmdln
%{_bindir}/besctl
%{_bindir}/besdaemon
%{_bindir}/beslistener
%{_bindir}/besstandalone
%{_bindir}/build_dmrpp
%{_bindir}/check_dmrpp
%{_bindir}/get_dmrpp
%{_bindir}/hyraxctl
%{_bindir}/ingest_filesystem
%{_bindir}/ingest_s3bucket
%{_bindir}/localBesGetDap
%{_bindir}/merge_dmrpp
%{_bindir}/populateMDS
%{_bindir}/reduce_mdf
%{_libdir}/*.so.*
%{_libdir}/bes/
%{bescachedir}
%{bespkidir}/
%attr (-,%{besuser},%{besgroup}) %{beslogdir}
%attr (-,%{besuser},%{besgroup}) %{_datadir}/mds/

%files devel
%doc __distribution_docs/BES_*.doc
%{_bindir}/besCreateModule
%{_bindir}/bes-config
%{_includedir}/bes/
%{_libdir}/*.so
%{_libdir}/pkgconfig/bes_*.pc
%{_datadir}/bes/templates/
%{_datadir}/aclocal/bes.m4

%files doc
%doc --no-dereference COPYING
%doc __distribution_docs/api-html/

%changelog
